/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter.airflow;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.airflow.AirflowDumpItem;
import com.aliyun.dataworks.migrationx.domain.dataworks.airflow.AirflowNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.airflow.AirflowWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.airflow.OperatorType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Asset;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.AssetType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.NodeUseType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.WorkflowVersion;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.NodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.loader.ProjectAssetLoader;
import com.aliyun.dataworks.migrationx.transformer.core.translator.TranslateUtils;
import com.aliyun.dataworks.migrationx.transformer.core.utils.EmrCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.AbstractBaseConverter;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.WorkflowConverter;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.utils.BeanUtils;
import com.aliyun.migrationx.common.utils.FileNameUtils;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirflowDagConverter
extends AbstractBaseConverter
implements WorkflowConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AirflowDagConverter.class);
    private static final String JSON_FILE_SUFFIX = ".json";
    private Properties properties = new Properties();
    private Project project;

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public AirflowDagConverter() {
        super(AssetType.AIRFLOW, "AirflowDagConverter");
    }

    public AirflowDagConverter(AssetType assetType, String name, ProjectAssetLoader projectAssetLoader) {
        super(assetType, name, projectAssetLoader);
    }

    public void setProject(Project project) {
        this.project = project;
    }

    @Override
    public List<DwWorkflow> convert(Asset asset) throws Exception {
        this.workflowList = new ArrayList();
        File airflowDir = asset.getPath();
        if (airflowDir == null || !airflowDir.exists()) {
            LOGGER.error("airflow asset dir invalid");
            return ListUtils.emptyIfNull(null);
        }
        for (File jsonFile : airflowDir.listFiles(file -> file.isFile() && file.getName().endsWith(JSON_FILE_SUFFIX))) {
            LOGGER.info("parsing airflow dump json: {}", (Object)jsonFile);
            String json = IOUtils.toString((Reader)new FileReader(jsonFile));
            List list = (List)GsonUtils.defaultGson.fromJson(json, new TypeToken<List<AirflowDumpItem>>(){}.getType());
            List wfs = list.stream().map(AirflowDumpItem::getWorkflow).filter(Objects::nonNull).map(this::toDwWorkflow).collect(Collectors.toList());
            this.workflowList.addAll(wfs);
        }
        ListUtils.emptyIfNull((List)this.workflowList).forEach(wf -> ListUtils.emptyIfNull((List)wf.getNodes()).forEach(n -> NodeUtils.setProjectRootDependencyIfIsolated((Project)this.project, (DwWorkflow)wf, (Node)n)));
        return this.workflowList;
    }

    private DwWorkflow toDwWorkflow(AirflowWorkflow airflowWorkflow) {
        DwWorkflow dwWorkflow = new DwWorkflow();
        dwWorkflow.setName(airflowWorkflow.getName());
        dwWorkflow.setScheduled(airflowWorkflow.getScheduled());
        dwWorkflow.setVersion(WorkflowVersion.V3);
        dwWorkflow.setNodes(ListUtils.emptyIfNull((List)airflowWorkflow.getNodes()).stream().map(airflow -> this.toDwNode(dwWorkflow, (AirflowNode)airflow)).peek(dwNode -> {
            dwNode.setNodeUseType(NodeUseType.SCHEDULED);
            ListUtils.emptyIfNull((List)dwNode.getInputs()).forEach(in -> in.setParseType(Integer.valueOf(1)));
            ListUtils.emptyIfNull((List)dwNode.getOutputs()).forEach(in -> in.setParseType(Integer.valueOf(1)));
        }).collect(Collectors.toList()));
        return dwWorkflow;
    }

    private DwNode toDwNode(DwWorkflow dwWorkflow, AirflowNode airflowNode) {
        DwNode dwNode = new DwNode();
        BeanUtils.copyProperties((Object)airflowNode, (Object)dwNode);
        dwNode.setName(FileNameUtils.normalizedFileName((String)dwNode.getName()));
        dwNode.setParameter(airflowNode.getParameters());
        dwNode.setCronExpress(dwNode.getCronExpress());
        dwNode.setIsAutoParse(Integer.valueOf(0));
        dwNode.setWorkflowRef((Workflow)dwWorkflow);
        LOGGER.debug("node parameters: {}, airflow parameters: {}", (Object)dwNode.getParameter(), (Object)airflowNode.getParameters());
        this.convertAirflowTask(dwNode, airflowNode);
        return dwNode;
    }

    private void convertAirflowTask(DwNode dwNode, AirflowNode airflowNode) {
        String operator;
        JsonObject airflowTask = airflowNode.getAirflowTask();
        if (StringUtils.isBlank((CharSequence)dwNode.getType()) && airflowTask == null) {
            LOGGER.error("invalid airflow task: {}", (Object)airflowNode);
            throw new RuntimeException("invalid airflow task " + airflowNode.getName());
        }
        LOGGER.debug("airflowTask: {}", (Object)airflowTask);
        if (StringUtils.isBlank((CharSequence)dwNode.getParameter()) && airflowTask.has("params") && airflowTask.get("params").getAsJsonObject() != null) {
            String params = Joiner.on((String)" ").join((Iterable)airflowTask.get("params").getAsJsonObject().keySet().stream().map(k -> Joiner.on((String)"=").join(k, (Object)String.valueOf(airflowTask.get("params").getAsJsonObject().get(k)), new Object[0])).collect(Collectors.toList()));
            dwNode.setParameter(params);
        }
        String string = operator = airflowTask.has("operator") && !airflowTask.get("operator").isJsonNull() ? airflowTask.get("operator").getAsString() : null;
        if (StringUtils.isBlank(operator)) {
            LOGGER.error("airflow task operator is blank: {}", (Object)airflowNode);
            throw new RuntimeException("airflow task operator is blank");
        }
        OperatorType operatorType = OperatorType.getOperatorTypeByName(operator);
        dwNode.setRawNodeType(operatorType.name());
        this.handleOperators(operatorType, dwNode, airflowTask);
    }

    private void handleOperators(OperatorType operator, DwNode dwNode, JsonObject airflowTask) {
        switch (operator) {
            case BashOperator: {
                this.processBashOperator(dwNode, airflowTask);
                return;
            }
            case PythonOperator: 
            case PythonVirtualenvOperator: 
            case BranchPythonOperator: 
            case _PythonDecoratedOperator: {
                this.processPythonOperator(dwNode, airflowTask);
                return;
            }
            case ExternalTaskSensor: 
            case ExternalTaskMarker: 
            case ExternalTaskSensorLink: {
                this.processAsVirtual(dwNode, airflowTask);
                return;
            }
        }
        this.processDefault(dwNode, airflowTask);
    }

    private void processAsVirtual(DwNode dwNode, JsonObject airflowTask) {
        dwNode.setType(CodeProgramType.VIRTUAL.name());
        dwNode.setCode(GsonUtils.toJsonString((Object)airflowTask));
    }

    private void processPythonOperator(DwNode dwNode, JsonObject airflowTask) {
        dwNode.setType(CodeProgramType.PYODPS.name());
        dwNode.setCode(airflowTask.has("python_callable") ? airflowTask.get("python_callable").getAsString() : "");
    }

    private void processDefault(DwNode dwNode, JsonObject airflowTask) {
        dwNode.setType(this.getDefaultTypeIfNotSupported(this.properties, CodeProgramType.DIDE_SHELL));
        dwNode.setDescription(BizException.of((ErrorCode)ErrorCode.PACKAGE_CONVERT_FAILED).with(new Object[]{dwNode.getType()}).getMessage());
        dwNode.setCode(GsonUtils.toJsonString((Object)airflowTask));
    }

    private void processBashOperator(DwNode dwNode, JsonObject airflowTask) {
        dwNode.setType((String)StringUtils.defaultIfBlank((CharSequence)this.properties.getProperty("workflow.converter.shellNodeType"), (CharSequence)CodeProgramType.DIDE_SHELL.name()));
        String bashCommand = airflowTask.get("bash_command") != null ? airflowTask.get("bash_command").getAsString() : null;
        dwNode.setCode((String)StringUtils.defaultIfBlank((CharSequence)dwNode.getCode(), (CharSequence)bashCommand));
        if (CodeProgramType.EMR_SHELL.name().equals(dwNode.getType())) {
            dwNode.setCode(EmrCodeUtils.toEmrCode((Node)dwNode));
        }
        if (airflowTask.has("env")) {
            JsonObject envs;
            JsonObject jsonObject = envs = airflowTask.get("env") instanceof JsonNull ? null : airflowTask.get("env").getAsJsonObject();
            if (envs != null) {
                dwNode.setParameter(GsonUtils.toJsonString((Object)envs));
            }
        }
        LOGGER.debug("node: {}, parameter: {}", (Object)dwNode.getName(), (Object)dwNode.getParameter());
        TranslateUtils.translateSparkSubmit(dwNode, this.properties);
        TranslateUtils.translateCommandSql((DwWorkflow)dwNode.getWorkflowRef(), dwNode, this.properties);
    }
}

