/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.converter;

import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Asset;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwWorkflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.NodeIo;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Project;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Workflow;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.AssetType;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.NodeUtils;
import com.aliyun.dataworks.migrationx.transformer.core.annotation.DependsOn;
import com.aliyun.dataworks.migrationx.transformer.core.controller.Task;
import com.aliyun.dataworks.migrationx.transformer.core.loader.ConfigPropertiesLoader;
import com.aliyun.dataworks.migrationx.transformer.core.loader.ProjectAssetLoader;
import com.aliyun.dataworks.migrationx.transformer.dataworks.converter.WorkflowConverter;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseConverter
extends Task<List<DwWorkflow>>
implements WorkflowConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBaseConverter.class);
    @DependsOn
    protected ConfigPropertiesLoader propertiesLoader;
    @DependsOn
    protected ProjectAssetLoader projectAssetLoader;
    protected List<DwWorkflow> workflowList;
    protected AssetType assetType;

    public AbstractBaseConverter(AssetType assetType, String name) {
        super(name);
        this.assetType = assetType;
    }

    public AbstractBaseConverter(AssetType assetType, String name, ProjectAssetLoader projectAssetLoader) {
        super(name);
        this.projectAssetLoader = projectAssetLoader;
        this.assetType = assetType;
    }

    public void setPropertiesLoader(ConfigPropertiesLoader propertiesLoader) {
        this.propertiesLoader = propertiesLoader;
    }

    public ConfigPropertiesLoader getPropertiesLoader() {
        return this.propertiesLoader;
    }

    @Override
    public List<DwWorkflow> call() throws Exception {
        List assets = (List)this.projectAssetLoader.getResult();
        if (CollectionUtils.isEmpty((Collection)assets)) {
            return ListUtils.emptyIfNull(null);
        }
        this.workflowList = new ArrayList<DwWorkflow>();
        for (Asset asset : assets.stream().filter(asset1 -> asset1.getType().equals((Object)this.assetType)).collect(Collectors.toList())) {
            List<DwWorkflow> workflows = this.convert(asset);
            if (CollectionUtils.isEmpty(workflows)) continue;
            this.workflowList.addAll(workflows);
        }
        return this.workflowList;
    }

    protected String getDefaultTypeIfNotSupported(Properties properties, CodeProgramType defaultNodeType) {
        Preconditions.checkNotNull((Object)properties, (Object)"converter properties should not be null");
        Preconditions.checkNotNull((Object)defaultNodeType, (Object)"default node type should not be null");
        return (String)StringUtils.defaultIfBlank((CharSequence)properties.getProperty("workflow.converter.target.unknownNodeTypeAs", null), (CharSequence)defaultNodeType.name());
    }

    protected String getDefaultCalcEngineDatasource(Properties properties, String defaultValue) {
        Preconditions.checkNotNull((Object)properties, (Object)"converter properties should not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)defaultValue), (Object)"calc engine default datasource should not be null");
        return (String)StringUtils.defaultIfBlank((CharSequence)properties.getProperty("workflow.converter.target.engine.datasource.name", null), (CharSequence)defaultValue);
    }

    protected CalcEngineType getDefaultCalcEngineType(Properties properties, CalcEngineType defaultType) {
        Preconditions.checkNotNull((Object)properties, (Object)"converter properties should not be null");
        Preconditions.checkNotNull((Object)defaultType, (Object)"default calc engine Type should not be null");
        return CalcEngineType.valueOf((String)properties.getProperty("workflow.converter.target.engine.datasource.type", defaultType.name()));
    }

    protected void setProjectRootDependForNoInputNode(Project project, List<DwWorkflow> workflows) {
        ListUtils.emptyIfNull(workflows).stream().filter(wf -> BooleanUtils.isTrue((Boolean)wf.getScheduled())).map(Workflow::getNodes).flatMap(Collection::stream).filter(Objects::nonNull).forEach(node -> {
            if (CollectionUtils.isEmpty((Collection)node.getInputs())) {
                NodeIo root = new NodeIo();
                root.setData(NodeUtils.getProjectRootOutput((Project)project));
                root.setParseType(Integer.valueOf(1));
                node.getInputs().add(root);
            }
        });
    }
}

