/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.dataworks.apps;

import com.aliyun.dataworks.common.spec.utils.JSONUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DataWorksPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.standard.objects.Package;
import com.aliyun.dataworks.migrationx.transformer.core.BaseTransformerApp;
import com.aliyun.dataworks.migrationx.transformer.core.transformer.Transformer;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksDolphinSchedulerTransformer;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksPackageFormat;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksTransformerConfig;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.WorkflowDolphinSchedulerTransformer;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.exception.BizException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.metrics.enums.CollectorType;
import com.aliyun.migrationx.common.utils.Config;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWorksDolphinschedulerTransformerApp
extends BaseTransformerApp {
    private static final Logger log = LoggerFactory.getLogger(DataWorksDolphinschedulerTransformerApp.class);

    public DataWorksDolphinschedulerTransformerApp() {
        super(DolphinSchedulerPackage.class, DataWorksPackage.class);
    }

    @Override
    public void initCollector() {
        TransformerContext.init((CollectorType)CollectorType.DolphinScheduler);
        super.initCollector();
    }

    @Override
    protected Transformer createTransformer(File configFile, Package from, Package to) {
        DolphinSchedulerPackage dolphinSchedulerPackage = (DolphinSchedulerPackage)from;
        DataWorksPackage dataWorksPackage = (DataWorksPackage)to;
        DataWorksTransformerConfig config = this.initConfig(configFile);
        log.info("dataworks transformer configFile: {} config: {}", (Object)configFile.getAbsolutePath(), (Object)config);
        if (config.getFormat() != null && DataWorksPackageFormat.WORKFLOW.equals((Object)config.getFormat())) {
            return new WorkflowDolphinSchedulerTransformer(config, dolphinSchedulerPackage, dataWorksPackage);
        }
        return new DataWorksDolphinSchedulerTransformer(config, dolphinSchedulerPackage, dataWorksPackage);
    }

    private DataWorksTransformerConfig initConfig(File configFile) {
        if (!configFile.exists()) {
            log.error("config file not exists: {}", (Object)configFile);
            throw new RuntimeException("file not found by " + configFile.getAbsolutePath());
        }
        try {
            String config = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
            DataWorksTransformerConfig dataWorksTransformerConfig = (DataWorksTransformerConfig)JSONUtils.parseObject((String)config, (TypeReference)new TypeReference<DataWorksTransformerConfig>(){});
            if (dataWorksTransformerConfig == null) {
                log.error("config file: {}, config class: {}", (Object)configFile, DataWorksTransformerConfig.class);
                throw new BizException(ErrorCode.PARSE_CONFIG_FILE_FAILED, new Object[0]).with(new Object[]{configFile});
            }
            Config dwConfig = (Config)GsonUtils.fromJsonString((String)config, (Type)new TypeToken<Config>(){}.getType());
            Config.init((Config)dwConfig);
            log.info("config replaceMapping {}", (Object)JSONUtils.toJsonString((Object)Config.get().getReplaceMapping()));
            return dataWorksTransformerConfig;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

