/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.utils;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrAllocationSpec;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrJobType;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrLauncher;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.EmrProperty;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Node;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.NodeUtils;
import com.aliyun.migrationx.common.utils.GsonUtils;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmrCodeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmrCodeUtils.class);

    public static EmrCode asEmrCode(Node node) {
        try {
            if (NodeUtils.isEmrNode((String)node.getType())) {
                return (EmrCode)GsonUtils.fromJsonString((String)node.getCode(), EmrCode.class);
            }
        }
        catch (Exception e) {
            LOGGER.error("convert to EmrCode failed code: {}, exception: ", (Object)node.getCode(), (Object)e);
        }
        return null;
    }

    public static EmrCode asEmrCode(String type, String code) {
        try {
            if (NodeUtils.isEmrNode((String)type)) {
                return (EmrCode)GsonUtils.fromJsonString((String)code, EmrCode.class);
            }
        }
        catch (Exception e) {
            LOGGER.error("convert to EmrCode failed code: {}, exception: ", (Object)code, (Object)e);
        }
        return null;
    }

    public static String toEmrCode(Node node) {
        CodeProgramType nodeType = CodeProgramType.valueOf((String)node.getType());
        EmrCode emrCode = new EmrCode();
        emrCode.setName(node.getName());
        emrCode.setDescription("DataWorks Migration");
        EmrLauncher launcher = new EmrLauncher();
        launcher.setAllocationSpec(EmrCodeUtils.getDefaultAllocationSpec());
        emrCode.setLauncher(launcher);
        EmrProperty properties = new EmrProperty();
        properties.setArguments(Arrays.asList(node.getCode()));
        properties.setTags(Arrays.asList(node.getName()));
        emrCode.setProperties(properties);
        switch (nodeType) {
            case EMR_HIVE: {
                emrCode.setType(EmrJobType.HIVE_SQL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_SHELL: {
                emrCode.setType(EmrJobType.SHELL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_IMPALA: {
                emrCode.setType(EmrJobType.IMPALA_SQL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_MR: {
                emrCode.setType(EmrJobType.MR);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_PRESTO: {
                emrCode.setType(EmrJobType.PRESTO_SQL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_SPARK: {
                emrCode.setType(EmrJobType.SPARK);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_SPARK_SHELL: {
                emrCode.setType(EmrJobType.SPARK_SHELL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_SPARK_SQL: {
                emrCode.setType(EmrJobType.SPARK_SQL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
        }
        return node.getCode();
    }

    public static String toEmrCode(CodeProgramType type, String taskName, String code) {
        EmrCode emrCode = new EmrCode();
        emrCode.setName(taskName);
        emrCode.setDescription("DataWorks Migration");
        EmrLauncher launcher = new EmrLauncher();
        launcher.setAllocationSpec(EmrCodeUtils.getDefaultAllocationSpec());
        emrCode.setLauncher(launcher);
        EmrProperty properties = new EmrProperty();
        properties.setArguments(Arrays.asList(code));
        properties.setTags(Arrays.asList(taskName));
        emrCode.setProperties(properties);
        switch (type) {
            case EMR_HIVE: {
                emrCode.setType(EmrJobType.HIVE_SQL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_SHELL: {
                emrCode.setType(EmrJobType.SHELL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_IMPALA: {
                emrCode.setType(EmrJobType.IMPALA_SQL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_MR: {
                emrCode.setType(EmrJobType.MR);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_PRESTO: {
                emrCode.setType(EmrJobType.PRESTO_SQL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_SPARK: {
                emrCode.setType(EmrJobType.SPARK);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_SPARK_SHELL: {
                emrCode.setType(EmrJobType.SPARK_SHELL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
            case EMR_SPARK_SQL: {
                emrCode.setType(EmrJobType.SPARK_SQL);
                return GsonUtils.toJsonString((Object)emrCode);
            }
        }
        return code;
    }

    private static Map<String, Object> getDefaultAllocationSpec() {
        EmrAllocationSpec allocationSpec = new EmrAllocationSpec();
        allocationSpec.setMemory(String.valueOf(2048));
        allocationSpec.setPriority(String.valueOf(1));
        allocationSpec.setVcores(String.valueOf(1));
        allocationSpec.setQueue("default");
        return allocationSpec.toMap();
    }

    public static String toString(EmrCode emrCode) {
        return GsonUtils.toJsonString((Object)emrCode);
    }
}

