/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.sqoop;

import com.aliyun.dataworks.migrationx.transformer.core.sqoop.BaseSqoopTool;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.ExportTool;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.ImportTool;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.OptionsFileUtil;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.SqoopOptions;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.SqoopTool;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sqoop
extends Configured
implements Tool {
    public static final Logger LOG = LoggerFactory.getLogger((String)Sqoop.class.getName());
    public static final String SQOOP_RETHROW_PROPERTY = "sqoop.throwOnError";
    public static final String SQOOP_OPTIONS_FILE_SPECIFIER = "--options-file";
    private SqoopTool tool;
    private SqoopOptions options;
    private String[] childPrgmArgs;

    public Sqoop(SqoopTool tool) {
        this(tool, null);
    }

    public Sqoop(SqoopTool tool, Configuration conf) {
        this(tool, conf, new SqoopOptions());
    }

    public Sqoop(SqoopTool tool, Configuration conf, SqoopOptions opts) {
        LOG.info("Running Sqoop version: ...");
        if (null != conf) {
            this.setConf(conf);
        }
        this.options = opts;
        this.options.setConf(this.getConf());
        this.tool = tool;
    }

    public SqoopOptions getOptions() {
        return this.options;
    }

    public SqoopTool getTool() {
        return this.tool;
    }

    public int run(String[] args) {
        if (this.options.getConf() == null) {
            this.options.setConf(this.getConf());
        }
        try {
            this.options = this.tool.parseArguments(args, null, this.options, false);
            this.tool.appendArgs(this.childPrgmArgs);
            this.tool.validateOptions(this.options);
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            System.err.println(e.getMessage());
            return 1;
        }
        return this.tool.run(this.options);
    }

    private String[] stashChildPrgmArgs(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            if (!"--".equals(argv[i])) continue;
            this.childPrgmArgs = Arrays.copyOfRange(argv, i, argv.length);
            return Arrays.copyOfRange(argv, 0, i);
        }
        return argv;
    }

    public static int runSqoop(Sqoop sqoop, String[] args) {
        try {
            String[] toolArgs = sqoop.stashChildPrgmArgs(args);
            return ToolRunner.run((Configuration)sqoop.getConf(), (Tool)sqoop, (String[])toolArgs);
        }
        catch (Exception e) {
            LOG.error("Got exception running Sqoop: " + e.toString());
            e.printStackTrace();
            if (System.getProperty(SQOOP_RETHROW_PROPERTY) != null) {
                throw new RuntimeException(e);
            }
            return 1;
        }
    }

    public static int runTool(String[] args, Configuration conf) {
        String[] expandedArgs = null;
        try {
            expandedArgs = OptionsFileUtil.expandArguments(args);
        }
        catch (Exception ex) {
            LOG.error("Error while expanding arguments", (Throwable)ex);
            System.err.println(ex.getMessage());
            System.err.println("Try 'sqoop help' for usage.");
            return 1;
        }
        String toolName = expandedArgs[0];
        BaseSqoopTool tool = null;
        if ("import".equalsIgnoreCase(toolName)) {
            tool = new ImportTool();
            tool.getCommonOptions().getOption("").getValue();
            tool.getInputFormatOptions();
            tool.getOutputFormatOptions();
        } else if ("export".equalsIgnoreCase(toolName)) {
            tool = new ExportTool();
        }
        if (null == tool) {
            System.err.println("No such sqoop tool: " + toolName + ". See 'sqoop help'.");
            return 1;
        }
        return 0;
    }

    public static int runTool(String[] args) {
        return Sqoop.runTool(args, new Configuration());
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Try 'sqoop help' for usage.");
            System.exit(1);
        }
        int ret = Sqoop.runTool(args);
        System.exit(ret);
    }

    static {
        Configuration.addDefaultResource((String)"sqoop-site.xml");
    }
}

