/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.sqoop;

import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.migrationx.transformer.core.report.ReportRiskLevel;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.AntCommandLine;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIConfigTemplate;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.DIJsonProcessor;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.ExportTool;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.ImportTool;
import com.aliyun.dataworks.migrationx.transformer.core.sqoop.SqoopOptions;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DICode {
    private static final Logger LOGGER = LoggerFactory.getLogger(DICode.class);
    private static final Pattern TARGET_DIR_PARTITION_PATTERN = Pattern.compile("([\\w-_]+=[\\w-_]+)");
    private static final String SQOOP_IMPORT = "import";
    private static final String SQOOP_EXPORT = "export";
    private static ThreadLocal<CalcEngineType> calcEngineType = ThreadLocal.withInitial(() -> CalcEngineType.ODPS);
    private static ThreadLocal<String> calcEngineDatasource = ThreadLocal.withInitial(() -> "odps_first");
    private static ThreadLocal<String> calcEngineDatasourceType = ThreadLocal.withInitial(() -> "odps");
    private String code;
    private String advice;
    private ReportRiskLevel riskLevel;
    private String description;
    private String message;
    private String exception;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAdvice() {
        return this.advice;
    }

    public void setAdvice(String advice) {
        this.advice = advice;
    }

    public ReportRiskLevel getRiskLevel() {
        return this.riskLevel;
    }

    public void setRiskLevel(ReportRiskLevel riskLevel) {
        this.riskLevel = riskLevel;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public static DICode parseDiCode(Element e) {
        return DICode.parseDiCode(e, null, null, null);
    }

    public static DICode parseDiCode(String code, CalcEngineType engineType, String datasourceName, String datasourceType) {
        String diCodeTemplate = DIConfigTemplate.DI_CODE_TEMPLATE;
        calcEngineType.set(engineType);
        calcEngineDatasource.set(datasourceName);
        calcEngineDatasourceType.set(datasourceType);
        DIJsonProcessor diCodeJP = DIJsonProcessor.from(diCodeTemplate);
        DICode diCode = new DICode();
        diCode.setRiskLevel(ReportRiskLevel.OK);
        try {
            DICode.parseSqoop(diCode, diCodeJP, code);
        }
        catch (Exception ex) {
            diCode.setRiskLevel(ReportRiskLevel.ERROR);
            diCode.setMessage(ex.getMessage());
            diCode.setException(ExceptionUtils.getStackTrace((Throwable)ex));
            diCode.setCode(null);
        }
        diCode.setCode(diCodeJP.toString());
        return diCode;
    }

    public static DICode parseDiCode(Element actionXml, CalcEngineType engineType, String datasourceName, String datasourceType) {
        String diCodeTemplate = DIConfigTemplate.DI_CODE_TEMPLATE;
        calcEngineType.set(engineType);
        calcEngineDatasource.set(datasourceName);
        calcEngineDatasourceType.set(datasourceType);
        DIJsonProcessor diCodeJP = DIJsonProcessor.from(diCodeTemplate);
        DICode diCode = new DICode();
        diCode.setRiskLevel(ReportRiskLevel.OK);
        try {
            DICode.parseSqoop(diCode, diCodeJP, actionXml);
        }
        catch (Exception ex) {
            diCode.setRiskLevel(ReportRiskLevel.ERROR);
            diCode.setMessage(ex.getMessage());
            diCode.setException(ExceptionUtils.getStackTrace((Throwable)ex));
            diCode.setCode(null);
        }
        diCode.setCode(diCodeJP.toString());
        return diCode;
    }

    public static DICode parseDiCode(String sqoopCommands) {
        String diCodeTemplate = DIConfigTemplate.DI_CODE_TEMPLATE;
        DIJsonProcessor diCodeJP = DIJsonProcessor.from(diCodeTemplate);
        DICode diCode = new DICode();
        diCode.setRiskLevel(ReportRiskLevel.OK);
        try {
            DICode.parseSqoop(diCode, diCodeJP, sqoopCommands);
        }
        catch (Exception ex) {
            LOGGER.error("{}", (Throwable)ex);
            diCode.setRiskLevel(ReportRiskLevel.ERROR);
            diCode.setMessage(ex.getMessage());
            diCode.setException(ExceptionUtils.getStackTrace((Throwable)ex));
            diCode.setCode(null);
        }
        diCode.setCode(diCodeJP.toString());
        return diCode;
    }

    private static void parseSqoop(DICode diCode, DIJsonProcessor diCodeJP, String sqoopCommands) {
        if (StringUtils.isBlank((CharSequence)sqoopCommands)) {
            diCode.setAdvice("ignore this sqoop node");
            diCode.setDescription("can not find sqoop config");
            diCode.setMessage("");
            diCode.setRiskLevel(ReportRiskLevel.WEEK_WARNINGS);
            diCode.setException(null);
        } else {
            DICode.doParseSqoop(diCode, diCodeJP, sqoopCommands);
        }
    }

    private static String[] parseSqoopArgs(String sqoopCommands) {
        AntCommandLine antCommandLine = new AntCommandLine(sqoopCommands);
        Iterator<AntCommandLine.Argument> itr = antCommandLine.iterator();
        ArrayList<String> args = new ArrayList<String>();
        boolean propertiesMeet = false;
        while (itr.hasNext()) {
            AntCommandLine.Argument arg = itr.next();
            Object[] parts = arg.getParts();
            if (parts == null) continue;
            if (parts != null && parts.length > 0) {
                if (parts[0].matches("-D$")) {
                    propertiesMeet = true;
                    continue;
                }
                if (((String)parts[0]).matches("^-D.+")) {
                    LOGGER.warn("ignore sqoop command -D: {}", parts[0]);
                    continue;
                }
            }
            if (parts != null && parts.length > 0 && propertiesMeet) {
                LOGGER.warn("ignore sqoop command -D: {}", parts);
                propertiesMeet = false;
                continue;
            }
            args.add(Joiner.on((String)" ").join((Object[])arg.getParts()));
        }
        String[] argArray = new String[args.size()];
        args.toArray(argArray);
        return argArray;
    }

    private static void parseSqoop(DICode diCode, DIJsonProcessor diCodeJP, Element e) {
        List allElements = e.getChildren();
        ArrayList<Element> sqoopArg = new ArrayList<Element>();
        for (Element each : allElements) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)each.getName(), (CharSequence)"arg")) continue;
            sqoopArg.add(each);
        }
        if (null == sqoopArg || sqoopArg.isEmpty()) {
            Element command = e.getChild("command", e.getNamespace());
            if (command != null && StringUtils.isNotBlank((CharSequence)command.getTextTrim())) {
                DICode.doParseSqoop(diCode, diCodeJP, command.getTextTrim());
            } else {
                diCode.setAdvice("ignore this sqoop node");
                diCode.setDescription("can not find sqoop config");
                diCode.setMessage("");
                diCode.setRiskLevel(ReportRiskLevel.WEEK_WARNINGS);
                diCode.setException(null);
            }
        } else {
            Object[] sqArgs = new String[sqoopArg.size()];
            for (int i = 0; i < sqoopArg.size(); ++i) {
                sqArgs[i] = ((Element)sqoopArg.get(i)).getValue();
            }
            DICode.doParseSqoop(diCode, diCodeJP, Joiner.on((String)" ").join(sqArgs));
        }
    }

    private static void doParseSqoop(DICode diCode, DIJsonProcessor diCodeJP, String sqoopCommands) {
        if (!sqoopCommands.startsWith("sqoop") && !sqoopCommands.startsWith("SQOOP")) {
            sqoopCommands = "sqoop " + sqoopCommands;
        }
        LOGGER.info("parse sqoop command: {}", (Object)sqoopCommands);
        DIJsonProcessor readerJp = diCodeJP.getConfiguration("steps[0]");
        DIJsonProcessor writerJp = diCodeJP.getConfiguration("steps[1]");
        String[] sqArgs = DICode.parseSqoopArgs(RegExUtils.replaceAll((String)sqoopCommands, (String)"\n-", (String)"\n -"));
        if (StringUtils.equalsIgnoreCase((CharSequence)StringUtils.trim((String)sqArgs[0]), (CharSequence)SQOOP_IMPORT)) {
            SqoopOptions importOptions;
            ImportTool tool = new ImportTool();
            try {
                importOptions = tool.parseArguments(sqArgs, null, new SqoopOptions(), false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            DICode.setRmdbsParameters(readerJp, importOptions);
            DICode.setOdpsParameter(writerJp, importOptions);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)StringUtils.trim((String)sqArgs[0]), (CharSequence)SQOOP_EXPORT)) {
            SqoopOptions exportOptions;
            ExportTool tool = new ExportTool();
            try {
                exportOptions = tool.parseArguments(sqArgs, null, new SqoopOptions(), false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            DICode.setOdpsParameter(readerJp, exportOptions);
            DICode.setRmdbsParameters(writerJp, exportOptions);
        } else if (!StringUtils.equalsIgnoreCase((CharSequence)StringUtils.trim((String)sqArgs[0]), (CharSequence)SQOOP_EXPORT)) {
            diCode.setAdvice("not support this transport");
            diCode.setDescription("not support this transport");
            diCode.setMessage("not support this transport");
            diCode.setRiskLevel(ReportRiskLevel.ERROR);
        }
    }

    private static void setOdpsParameter(DIJsonProcessor writerJp, SqoopOptions sqoopOptions) {
        writerJp.set("stepType", calcEngineDatasourceType.get());
        writerJp.set("parameter.datasource", calcEngineDatasource.get());
        writerJp.set("parameter.column", new String[]{"*"});
        if (sqoopOptions.getColumns() != null) {
            writerJp.set("parameter.column", sqoopOptions.getColumns());
        }
        writerJp.set("parameter.table", sqoopOptions.getHiveTableName());
        if (StringUtils.isNotBlank((CharSequence)sqoopOptions.getHivePartitionKey()) && StringUtils.isNotBlank((CharSequence)sqoopOptions.getHivePartitionValue())) {
            String partition = Joiner.on((String)"=").join((Object)sqoopOptions.getHivePartitionKey(), (Object)sqoopOptions.getHivePartitionValue(), new Object[0]);
            writerJp.set("parameter.partition", partition);
        } else if (StringUtils.isNotBlank((CharSequence)sqoopOptions.getTargetDir())) {
            String partitions = DICode.getMatchedPartitionsByTargetDir(sqoopOptions.getTargetDir());
            writerJp.set("parameter.partition", partitions);
        }
        writerJp.set("parameter.truncate", "true");
    }

    private static String getMatchedPartitionsByTargetDir(String targetDir) {
        Matcher matcher = TARGET_DIR_PARTITION_PATTERN.matcher(targetDir);
        ArrayList<String> groups = new ArrayList<String>();
        while (matcher.find()) {
            String group = matcher.group();
            groups.add(group);
        }
        return Joiner.on((String)",").join(groups);
    }

    private static void setRmdbsParameters(DIJsonProcessor readerJp, SqoopOptions sqoopOptions) {
        String whereClause;
        readerJp.set("stepType", "mysql");
        readerJp.set("parameter.connection[0].jdbcUrl", Arrays.asList(sqoopOptions.getConnectString()));
        if (StringUtils.isNotBlank((CharSequence)sqoopOptions.getTableName())) {
            readerJp.set("parameter.connection[0].table", Arrays.asList(sqoopOptions.getTableName()));
        }
        if (StringUtils.isNotBlank((CharSequence)sqoopOptions.getSqlQuery())) {
            readerJp.set("parameter.connection[0].querySql", Arrays.asList(sqoopOptions.getSqlQuery()));
        }
        readerJp.set("parameter.column", new String[]{"*"});
        if (sqoopOptions.getColumns() != null && sqoopOptions.getColumns().length > 0) {
            readerJp.set("parameter.column", sqoopOptions.getColumns());
        }
        if (StringUtils.isNotBlank((CharSequence)(whereClause = DICode.processWhereClause(sqoopOptions)))) {
            readerJp.set("parameter.where", whereClause);
        }
        readerJp.set("parameter.username", sqoopOptions.getUsername());
        readerJp.set("parameter.password", sqoopOptions.getPassword());
    }

    private static String processWhereClause(SqoopOptions sqoopOptions) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)sqoopOptions.getWhereClause())) {
            whereClauses.add("(" + sqoopOptions.getWhereClause() + " )");
        }
        if (sqoopOptions.getIncrementalMode() != null) {
            switch (sqoopOptions.getIncrementalMode()) {
                case DateLastModified: {
                    whereClauses.add("(" + sqoopOptions.getIncrementalTestColumn() + " >= '" + sqoopOptions.getIncrementalLastValue() + "' AND " + sqoopOptions.getIncrementalTestColumn() + " < now())");
                    break;
                }
                case AppendRows: {
                    whereClauses.add("(" + sqoopOptions.getIncrementalTestColumn() + " > " + sqoopOptions.getIncrementalLastValue() + ")");
                    break;
                }
            }
        }
        return Joiner.on((String)" AND ").join(whereClauses).replaceAll("^\\(", "").replaceAll("\\)$", "");
    }
}

