/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.spark.command;

import com.aliyun.dataworks.migrationx.transformer.core.spark.command.AbstractLauncher;
import com.aliyun.dataworks.migrationx.transformer.core.spark.command.CommandBuilderUtils;
import com.aliyun.dataworks.migrationx.transformer.core.spark.command.InProcessAppHandle;
import com.aliyun.dataworks.migrationx.transformer.core.spark.command.LauncherServer;
import com.aliyun.dataworks.migrationx.transformer.core.spark.command.SparkAppHandle;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.logging.Logger;

public class InProcessLauncher
extends AbstractLauncher<InProcessLauncher> {
    private static final Logger LOG = Logger.getLogger(InProcessLauncher.class.getName());

    @Override
    public SparkAppHandle startApplication(SparkAppHandle.Listener ... listeners) throws IOException {
        if (this.builder.isClientMode(this.builder.getEffectiveConfig())) {
            LOG.warning("It's not recommended to run client-mode applications using InProcessLauncher.");
        }
        Method main = this.findSparkSubmit();
        LauncherServer server = LauncherServer.getOrCreateServer();
        InProcessAppHandle handle = new InProcessAppHandle(server);
        for (SparkAppHandle.Listener l : listeners) {
            handle.addListener(l);
        }
        String secret = server.registerHandle(handle);
        this.setConf("spark.launcher.port", String.valueOf(server.getPort()));
        this.setConf("spark.launcher.secret", secret);
        List<String> sparkArgs = this.builder.buildSparkSubmitArgs();
        String[] argv = sparkArgs.toArray(new String[sparkArgs.size()]);
        String appName = CommandBuilderUtils.firstNonEmpty(this.builder.appName, this.builder.mainClass, "<unknown>");
        handle.start(appName, main, argv);
        return handle;
    }

    @Override
    InProcessLauncher self() {
        return this;
    }

    Method findSparkSubmit() throws IOException {
        Method main;
        Class<?> sparkSubmit;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            sparkSubmit = cl.loadClass("org.apache.spark.deploy.InProcessSparkSubmit");
        }
        catch (Exception e1) {
            try {
                sparkSubmit = cl.loadClass("org.apache.spark.deploy.SparkSubmit");
            }
            catch (Exception e2) {
                throw new IOException("Cannot find SparkSubmit; make sure necessary jars are available.", e2);
            }
        }
        try {
            main = sparkSubmit.getMethod("main", String[].class);
        }
        catch (Exception e) {
            throw new IOException("Cannot find SparkSubmit main method.", e);
        }
        CommandBuilderUtils.checkState(Modifier.isStatic(main.getModifiers()), "main method is not static.", new Object[0]);
        return main;
    }
}

