/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.loader;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.ResourceUtils;
import com.aliyun.dataworks.migrationx.transformer.core.common.Constants;
import com.aliyun.dataworks.migrationx.transformer.core.controller.Task;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectResourceLoader
extends Task<List<DwResource>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectResourceLoader.class);
    private String projectDir;
    private List<DwResource> resources = new ArrayList<DwResource>();

    public ProjectResourceLoader(String projectDir) {
        super(ProjectResourceLoader.class.getSimpleName());
        this.projectDir = projectDir;
    }

    public ProjectResourceLoader(String projectDir, String name) {
        super(name);
        this.projectDir = projectDir;
    }

    @Override
    public List<DwResource> call() {
        File resourceDir = new File(Joiner.on((String)File.separator).join((Object)this.projectDir, (Object)Constants.SRC_DIR_PRJ_RELATED, new Object[]{"resources"}));
        if (!resourceDir.exists()) {
            return this.resources;
        }
        this.resources = Arrays.asList(resourceDir.listFiles()).stream().map(file -> {
            DwResource res = new DwResource();
            res.setName(file.getName());
            res.setLocalPath(file.getAbsolutePath());
            res.setType(ResourceUtils.getFileResourceType((String)file.getName()));
            return res;
        }).collect(Collectors.toList());
        LOGGER.info("load {} resources", (Object)this.resources.size());
        return this.resources;
    }
}

