/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.loader;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.Asset;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.types.AssetType;
import com.aliyun.dataworks.migrationx.transformer.core.common.Constants;
import com.aliyun.dataworks.migrationx.transformer.core.controller.Task;
import com.aliyun.dataworks.migrationx.transformer.core.report.Reportable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectAssetLoader
extends Task<List<Asset>>
implements Reportable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectAssetLoader.class);
    private String projectDir;
    private List<Asset> assetList = new ArrayList<Asset>();

    public ProjectAssetLoader(String projectDir) {
        super(ProjectAssetLoader.class.getSimpleName());
        this.projectDir = projectDir;
    }

    public ProjectAssetLoader(String projectDir, String name) {
        super(name);
        this.projectDir = projectDir;
    }

    @Override
    public List<Asset> call() throws Exception {
        File projectPath = new File(this.projectDir);
        File assetPath = new File(projectPath.getAbsolutePath() + File.separator + Constants.SRC_DIR_PRJ_RELATED + File.separator + "assets");
        if (!assetPath.exists()) {
            return this.assetList;
        }
        for (File assetDir : Objects.requireNonNull(assetPath.listFiles(f -> f.isDirectory() && !f.isHidden() && !f.getName().startsWith(".")))) {
            try {
                AssetType type = AssetType.getAssetType((String)assetDir.getName());
                Asset asset = new Asset();
                asset.setType(type);
                asset.setPath(assetDir);
                this.assetList.add(asset);
            }
            catch (Exception e) {
                LOGGER.error("{}", (Object)e.getMessage());
            }
        }
        return this.assetList;
    }
}

