/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.transformer.core.checkpoint.file;

import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwNode;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DwResource;
import com.aliyun.dataworks.migrationx.transformer.core.checkpoint.CheckPoint;
import com.aliyun.dataworks.migrationx.transformer.core.checkpoint.file.BufferedFileWriter;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileCheckPoint<SPEC>
implements CheckPoint<BufferedFileWriter, SPEC> {
    private static final Logger log = LoggerFactory.getLogger(LocalFileCheckPoint.class);
    public static final String SUFFIX = ".ckpt";
    private static final boolean FILE_APPEND = true;
    private final TypeReference<List<SPEC>> REF = new TypeReference<List<SPEC>>(){};
    private static final PolymorphicTypeValidator ptv = BasicPolymorphicTypeValidator.builder().allowIfSubType(DwNode.class).allowIfSubType(DwResource.class).build();
    private final ObjectMapper objectMapper = new ObjectMapper().setPolymorphicTypeValidator(ptv);

    @Override
    public List<SPEC> doWithCheckpoint(Function<BufferedFileWriter, List<SPEC>> checkpointFunc, String projectName) {
        File checkpoint = TransformerContext.getContext().getCheckpoint();
        if (checkpoint == null) {
            log.info("checkpoint is null, skip");
            return checkpointFunc.apply(null);
        }
        File target = new File(checkpoint.getAbsolutePath() + File.separator + projectName + SUFFIX);
        log.info("do with checkpoint {}", (Object)target.getAbsolutePath());
        return this.doWithCheckpoint(checkpointFunc, target);
    }

    /*
     * Exception decompiling
     */
    public List<SPEC> doWithCheckpoint(Function<BufferedFileWriter, List<SPEC>> checkpointFunc, File target) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void doCheckpoint(BufferedFileWriter writer, List<SPEC> workflows, String processName, String taskName) {
        if (writer == null) {
            return;
        }
        HashMap<String, List<SPEC>> dataMap = new HashMap<String, List<SPEC>>();
        dataMap.put(taskName, workflows);
        String data = this.toJson(workflows);
        try {
            writer.writeLine(data, processName, taskName);
            log.info("successful write checkpoint with project: {} processName: {} task: {}", (Object)processName, (Object)taskName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, List<SPEC>> loadFromCheckPoint(String projectName, String processName) {
        File dir = TransformerContext.getContext().getLoad();
        Map<String, List<SPEC>> workflowMap = null;
        if (dir != null && dir.exists() && dir.isDirectory()) {
            for (File checkFile : dir.listFiles()) {
                if (!checkFile.getName().endsWith(projectName + SUFFIX)) continue;
                workflowMap = this.loadFromCheckpoint(checkFile, processName);
            }
        }
        if (workflowMap == null) {
            workflowMap = Collections.EMPTY_MAP;
        }
        return workflowMap;
    }

    private Map<String, List<SPEC>> loadFromCheckpoint(File checkpointFile, String qProcessName) {
        HashMap<String, List<SPEC>> workflowMap = new HashMap<String, List<SPEC>>();
        LineConsumer lineConsumer = (processName, taskName, line) -> {
            if (qProcessName.equals(processName)) {
                List<SPEC> taskMap = this.parseJson(line);
                workflowMap.putIfAbsent(taskName, taskMap);
            }
        };
        this.doLoad(checkpointFile, lineConsumer);
        return workflowMap;
    }

    private void doLoad(File checkpointFile, LineConsumer lineConsumer) {
        try (FileInputStream in = new FileInputStream(checkpointFile);
             InputStreamReader streamReader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(streamReader);){
            this.readFile(reader, lineConsumer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void readFile(BufferedReader reader, LineConsumer consumer) throws IOException {
        int len;
        while ((len = reader.read()) != -1) {
            this.readFile(reader, len, consumer);
        }
    }

    private void readFile(BufferedReader reader, int len, LineConsumer lineConsumer) throws IOException {
        char[] processBytes = new char[len];
        reader.read(processBytes);
        String processName = new String(processBytes);
        len = reader.read();
        char[] taskBytes = new char[len];
        reader.read(taskBytes);
        String taskName = new String(taskBytes);
        String line = reader.readLine();
        lineConsumer.consume(processName, taskName, line);
    }

    private String toJson(Object o) {
        try {
            return this.objectMapper.writeValueAsString(o);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<SPEC> parseJson(String json) {
        try {
            List lists = (List)this.objectMapper.readerFor(this.REF).readValue(json);
            return lists;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static interface LineConsumer {
        public void consume(String var1, String var2, String var3);
    }
}

