/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.dw.dbr.converter;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbrNotebookConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(DbrNotebookConvert.class);

    public DbrNotebookConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public DbrNotebookConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> res = new ArrayList<WorkflowNode>();
        if (CollectionUtils.isEmpty(workflowNodes)) {
            return res;
        }
        for (WorkflowNode workflowNode : workflowNodes) {
            WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
            if (Objects.isNull(tgtworkflowNode)) {
                log.error("not copy WorkflowNode {}", (Object)workflowNode.getNodeName());
                continue;
            }
            JSONObject notebookJson = JSON.parseObject((String)tgtworkflowNode.getScript());
            JSONObject resNotebookJson = new JSONObject();
            if (notebookJson != null) {
                JSONObject notebookMeta;
                String defaultFromat = "python";
                if (notebookJson.containsKey("metadata") && (notebookMeta = notebookJson.getJSONObject("metadata")).containsKey("language_info")) {
                    defaultFromat = notebookMeta.getJSONObject("language_info").getString("name");
                }
                JSONArray resCells = new JSONArray();
                if (notebookJson.containsKey("cells")) {
                    JSONArray notebookCells = notebookJson.getJSONArray("cells");
                    for (int i = 0; i < notebookCells.size(); ++i) {
                        JSONObject notebookCell = notebookCells.getJSONObject(i);
                        JSONObject resNotebookCell = new JSONObject();
                        resNotebookCell.put((Object)"cell_type", (Object)notebookCell.getString("cell_type"));
                        if (!notebookCell.containsKey("source")) continue;
                        JSONArray sourceArr = notebookCell.getJSONArray("source");
                        String headStr = sourceArr.getString(0);
                        JSONObject resCellMetaJson = new JSONObject();
                        if ("sql".equalsIgnoreCase(defaultFromat) && "%sql".equalsIgnoreCase(headStr)) {
                            dwCellMetaJson = new JSONObject();
                            dwCellMetaJson.put((Object)"nodeType", (Object)"ODPS_SQL");
                            resCellMetaJson.put((Object)"dataworks", (Object)dwCellMetaJson);
                        } else if ("python".equalsIgnoreCase(defaultFromat) || "%python".equalsIgnoreCase(headStr)) {
                            dwCellMetaJson = new JSONObject();
                            dwCellMetaJson.put((Object)"nodeType", (Object)"python");
                            resCellMetaJson.put((Object)"dataworks", (Object)dwCellMetaJson);
                        } else if ("markdown".equalsIgnoreCase(defaultFromat) && "%markdown".equalsIgnoreCase(headStr)) {
                            dwCellMetaJson = new JSONObject();
                            dwCellMetaJson.put((Object)"nodeType", (Object)"markdown");
                            resCellMetaJson.put((Object)"dataworks", (Object)dwCellMetaJson);
                        }
                        resNotebookCell.put((Object)"metadata", (Object)resCellMetaJson);
                        resNotebookCell.put((Object)"source", (Object)sourceArr);
                        resNotebookCell.put((Object)"outputs", (Object)new JSONArray());
                        resCells.add((Object)resNotebookCell);
                    }
                    resNotebookJson.put((Object)"cells", (Object)resCells);
                    resNotebookJson.put((Object)"nbformat", (Object)notebookJson.getInteger("nbformat"));
                    resNotebookJson.put((Object)"nbformat_minor", (Object)notebookJson.getInteger("nbformat_minor"));
                    resNotebookJson.put((Object)"metadata", (Object)new JSONObject());
                }
            }
            tgtworkflowNode.setNodeType("NOTEBOOK");
            tgtworkflowNode.setScript(resNotebookJson.toJSONString(new JSONWriter.Feature[0]));
            res.add(tgtworkflowNode);
        }
        return res;
    }
}

