/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

public final class RefreshResult<T> {
    private final T value;
    private final long staleTime;
    private final long prefetchTime;

    private RefreshResult(Builder<T> builder) {
        this.value = ((Builder)builder).value;
        this.staleTime = ((Builder)builder).staleTime;
        this.prefetchTime = ((Builder)builder).prefetchTime;
    }

    public static <T> Builder<T> builder(T value) {
        return new Builder(value);
    }

    public T value() {
        return this.value;
    }

    public long staleTime() {
        return this.staleTime;
    }

    public long prefetchTime() {
        return this.prefetchTime;
    }

    public String toString() {
        return String.format("RefreshResult(value=%s, staleTime=%d, prefetchTime=%d)", this.value, this.staleTime, this.prefetchTime);
    }

    public Builder<T> toBuilder() {
        return new Builder(this);
    }

    public static final class Builder<T> {
        private final T value;
        private long staleTime = Long.MAX_VALUE;
        private long prefetchTime = Long.MAX_VALUE;

        private Builder(T value) {
            this.value = value;
        }

        private Builder(RefreshResult<T> value) {
            this.value = ((RefreshResult)value).value;
            this.staleTime = ((RefreshResult)value).staleTime;
            this.prefetchTime = ((RefreshResult)value).prefetchTime;
        }

        public Builder<T> staleTime(long staleTime) {
            this.staleTime = staleTime;
            return this;
        }

        public Builder<T> prefetchTime(long prefetchTime) {
            this.prefetchTime = prefetchTime;
            return this;
        }

        public RefreshResult<T> build() {
            return new RefreshResult(this);
        }
    }
}

