/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.task.paramparser;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.spi.enums.CommandType;
import org.apache.dolphinscheduler.spi.utils.DateUtils;

public class BusinessTimeUtils {
    private BusinessTimeUtils() {
        throw new IllegalStateException("BusinessTimeUtils class");
    }

    public static Map<String, String> getBusinessTime(CommandType commandType, Date runTime) {
        Date businessDate = runTime;
        switch (commandType) {
            case COMPLEMENT_DATA: {
                break;
            }
            default: {
                businessDate = DateUtils.addDays(new Date(), -1);
                if (runTime == null) break;
                businessDate = DateUtils.addDays(runTime, -1);
            }
        }
        Date businessCurrentDate = DateUtils.addDays(businessDate, 1);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("system.biz.curdate", DateUtils.format(businessCurrentDate, "yyyyMMdd"));
        result.put("system.biz.date", DateUtils.format(businessDate, "yyyyMMdd"));
        result.put("system.datetime", DateUtils.format(businessCurrentDate, "yyyyMMddHHmmss"));
        return result;
    }
}

