/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.securitysdk.javax.xml.validation;

import com.alibaba.securitysdk.javax.xml.transform.Source;
import com.alibaba.securitysdk.javax.xml.transform.stream.StreamSource;
import com.alibaba.securitysdk.javax.xml.validation.Schema;
import com.alibaba.securitysdk.javax.xml.validation.SchemaFactoryFinder;
import com.alibaba.securitysdk.javax.xml.validation.SecuritySupport;
import com.alibaba.securitysdk.org.w3c.dom.ls.LSResourceResolver;
import com.alibaba.securitysdk.org.xml.sax.ErrorHandler;
import com.alibaba.securitysdk.org.xml.sax.SAXException;
import com.alibaba.securitysdk.org.xml.sax.SAXNotRecognizedException;
import com.alibaba.securitysdk.org.xml.sax.SAXNotSupportedException;
import java.io.File;
import java.net.URL;

public abstract class SchemaFactory {
    protected SchemaFactory() {
    }

    public static final SchemaFactory newInstance(String schemaLanguage) {
        SchemaFactory f;
        ClassLoader cl = SecuritySupport.getContextClassLoader();
        if (cl == null) {
            cl = SchemaFactory.class.getClassLoader();
        }
        if ((f = new SchemaFactoryFinder(cl).newFactory(schemaLanguage)) == null) {
            throw new IllegalArgumentException(schemaLanguage);
        }
        return f;
    }

    public static SchemaFactory newInstance(String schemaLanguage, String factoryClassName, ClassLoader classLoader) {
        SchemaFactory f;
        if (schemaLanguage == null) {
            throw new NullPointerException();
        }
        if (factoryClassName == null) {
            throw new IllegalArgumentException("factoryClassName cannot be null.");
        }
        if (classLoader == null) {
            classLoader = SecuritySupport.getContextClassLoader();
        }
        if ((f = new SchemaFactoryFinder(classLoader).createInstance(factoryClassName)) == null || !f.isSchemaLanguageSupported(schemaLanguage)) {
            throw new IllegalArgumentException(schemaLanguage);
        }
        return f;
    }

    public abstract boolean isSchemaLanguageSupported(String var1);

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(name);
    }

    public void setProperty(String name, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(name);
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name == null) {
            throw new NullPointerException("the name parameter is null");
        }
        throw new SAXNotRecognizedException(name);
    }

    public abstract void setErrorHandler(ErrorHandler var1);

    public abstract ErrorHandler getErrorHandler();

    public abstract void setResourceResolver(LSResourceResolver var1);

    public abstract LSResourceResolver getResourceResolver();

    public Schema newSchema(Source schema) throws SAXException {
        return this.newSchema(new Source[]{schema});
    }

    public Schema newSchema(File schema) throws SAXException {
        return this.newSchema(new StreamSource(schema));
    }

    public Schema newSchema(URL schema) throws SAXException {
        return this.newSchema(new StreamSource(schema.toExternalForm()));
    }

    public abstract Schema newSchema(Source[] var1) throws SAXException;

    public abstract Schema newSchema() throws SAXException;
}

