/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.utils;

import com.aliyun.akless.idprovider.model.EnvConfig;
import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JwtUtil {
    public static Date getTokenExpirationDate(String jwt) throws JWTDecodeException {
        DecodedJWT decodedJWT = JwtUtil.decodeJwt(jwt);
        return decodedJWT.getExpiresAt();
    }

    public static boolean checkJwtExpired(String jwt) {
        Date expiresAt;
        try {
            expiresAt = JwtUtil.getTokenExpirationDate(jwt);
        }
        catch (Exception e) {
            return true;
        }
        return expiresAt.before(new Date());
    }

    public static EnvConfig parseEnvConfigFromToken(String token, String appName) {
        DecodedJWT decodedJWT = JwtUtil.decodeJwt(token);
        String iss = decodedJWT.getIssuer();
        Pattern pattern = Pattern.compile("https://aliyun-app-idp-(.+?)\\.(.+)");
        Matcher matcher = pattern.matcher(iss);
        if (!matcher.find() || matcher.groupCount() != 2) {
            throw new RuntimeException("invalid token issuer: " + iss);
        }
        String sub = decodedJWT.getSubject();
        String[] appMeta = sub.split(":");
        if (appMeta.length != 3) {
            throw new RuntimeException("invalid token subject: " + sub);
        }
        if (!appName.isEmpty() && !appMeta[0].equals(appName)) {
            throw new RuntimeException(String.format("input app name %s is not consistent with the one extracted from bootstrap token", appName));
        }
        return new EnvConfig(matcher.group(1), "", appMeta[0], appMeta[2], appMeta[1], "");
    }

    private static DecodedJWT decodeJwt(String jwt) {
        DecodedJWT decodedJWT = JWT.decode((String)jwt);
        if (decodedJWT.getHeaderClaim("kid") == null) {
            throw new JWTDecodeException("kid not found in headers");
        }
        return decodedJWT;
    }
}

