/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.shaded.io.grpc;

import com.aliyun.akless.idprovider.shaded.com.google.common.annotations.VisibleForTesting;
import com.aliyun.akless.idprovider.shaded.com.google.common.base.Preconditions;
import com.aliyun.akless.idprovider.shaded.io.grpc.Codec;
import com.aliyun.akless.idprovider.shaded.io.grpc.Compressor;
import com.aliyun.akless.idprovider.shaded.io.grpc.ExperimentalApi;
import com.aliyun.akless.idprovider.shaded.javax.annotation.Nullable;
import com.aliyun.akless.idprovider.shaded.javax.annotation.concurrent.ThreadSafe;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1704")
@ThreadSafe
public final class CompressorRegistry {
    private static final CompressorRegistry DEFAULT_INSTANCE = new CompressorRegistry(new Codec.Gzip(), Codec.Identity.NONE);
    private final ConcurrentMap<String, Compressor> compressors = new ConcurrentHashMap<String, Compressor>();

    public static CompressorRegistry getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static CompressorRegistry newEmptyInstance() {
        return new CompressorRegistry(new Compressor[0]);
    }

    @VisibleForTesting
    CompressorRegistry(Compressor ... cs) {
        for (Compressor c : cs) {
            this.compressors.put(c.getMessageEncoding(), c);
        }
    }

    @Nullable
    public Compressor lookupCompressor(String compressorName) {
        return (Compressor)this.compressors.get(compressorName);
    }

    public void register(Compressor c) {
        String encoding = c.getMessageEncoding();
        Preconditions.checkArgument(!encoding.contains(","), "Comma is currently not allowed in message encoding");
        this.compressors.put(encoding, c);
    }
}

