/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.shaded.io.grpc;

import com.aliyun.akless.idprovider.shaded.com.google.common.base.MoreObjects;
import com.aliyun.akless.idprovider.shaded.com.google.common.base.Preconditions;
import com.aliyun.akless.idprovider.shaded.io.grpc.Attributes;
import com.aliyun.akless.idprovider.shaded.io.grpc.CallOptions;
import com.aliyun.akless.idprovider.shaded.io.grpc.ExperimentalApi;
import com.aliyun.akless.idprovider.shaded.io.grpc.Internal;
import com.aliyun.akless.idprovider.shaded.io.grpc.Metadata;
import com.aliyun.akless.idprovider.shaded.io.grpc.StreamTracer;
import com.aliyun.akless.idprovider.shaded.javax.annotation.concurrent.ThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
@ThreadSafe
public abstract class ClientStreamTracer
extends StreamTracer {
    public void streamCreated(Attributes transportAttrs, Metadata headers) {
    }

    public void outboundHeaders() {
    }

    public void inboundHeaders() {
    }

    public void inboundTrailers(Metadata trailers) {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
    public static final class StreamInfo {
        private final Attributes transportAttrs;
        private final CallOptions callOptions;
        private final int previousAttempts;
        private final boolean isTransparentRetry;

        StreamInfo(Attributes transportAttrs, CallOptions callOptions, int previousAttempts, boolean isTransparentRetry) {
            this.transportAttrs = Preconditions.checkNotNull(transportAttrs, "transportAttrs");
            this.callOptions = Preconditions.checkNotNull(callOptions, "callOptions");
            this.previousAttempts = previousAttempts;
            this.isTransparentRetry = isTransparentRetry;
        }

        @Deprecated
        public Attributes getTransportAttrs() {
            return this.transportAttrs;
        }

        public CallOptions getCallOptions() {
            return this.callOptions;
        }

        public int getPreviousAttempts() {
            return this.previousAttempts;
        }

        public boolean isTransparentRetry() {
            return this.isTransparentRetry;
        }

        public Builder toBuilder() {
            return new Builder().setCallOptions(this.callOptions).setTransportAttrs(this.transportAttrs).setPreviousAttempts(this.previousAttempts).setIsTransparentRetry(this.isTransparentRetry);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("transportAttrs", this.transportAttrs).add("callOptions", this.callOptions).add("previousAttempts", this.previousAttempts).add("isTransparentRetry", this.isTransparentRetry).toString();
        }

        public static final class Builder {
            private Attributes transportAttrs = Attributes.EMPTY;
            private CallOptions callOptions = CallOptions.DEFAULT;
            private int previousAttempts;
            private boolean isTransparentRetry;

            Builder() {
            }

            @Deprecated
            public Builder setTransportAttrs(Attributes transportAttrs) {
                this.transportAttrs = Preconditions.checkNotNull(transportAttrs, "transportAttrs cannot be null");
                return this;
            }

            public Builder setCallOptions(CallOptions callOptions) {
                this.callOptions = Preconditions.checkNotNull(callOptions, "callOptions cannot be null");
                return this;
            }

            public Builder setPreviousAttempts(int previousAttempts) {
                this.previousAttempts = previousAttempts;
                return this;
            }

            public Builder setIsTransparentRetry(boolean isTransparentRetry) {
                this.isTransparentRetry = isTransparentRetry;
                return this;
            }

            public StreamInfo build() {
                return new StreamInfo(this.transportAttrs, this.callOptions, this.previousAttempts, this.isTransparentRetry);
            }
        }
    }

    @Internal
    public static abstract class InternalLimitedInfoFactory
    extends Factory {
    }

    public static abstract class Factory {
        public ClientStreamTracer newClientStreamTracer(StreamInfo info, Metadata headers) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

