/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.shaded.com.github.rholder.retry;

import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.Attempt;
import com.aliyun.akless.idprovider.shaded.com.google.common.base.Preconditions;
import com.aliyun.akless.idprovider.shaded.javax.annotation.Nonnull;
import com.aliyun.akless.idprovider.shaded.javax.annotation.concurrent.Immutable;

@Immutable
public final class RetryException
extends Exception {
    private final int numberOfFailedAttempts;
    private final Attempt<?> lastFailedAttempt;

    public RetryException(int numberOfFailedAttempts, @Nonnull Attempt<?> lastFailedAttempt) {
        this("Retrying failed to complete successfully after " + numberOfFailedAttempts + " attempts.", numberOfFailedAttempts, lastFailedAttempt);
    }

    public RetryException(String message, int numberOfFailedAttempts, Attempt<?> lastFailedAttempt) {
        super(message, Preconditions.checkNotNull(lastFailedAttempt, "Last attempt was null").hasException() ? lastFailedAttempt.getExceptionCause() : null);
        this.numberOfFailedAttempts = numberOfFailedAttempts;
        this.lastFailedAttempt = lastFailedAttempt;
    }

    public int getNumberOfFailedAttempts() {
        return this.numberOfFailedAttempts;
    }

    public Attempt<?> getLastFailedAttempt() {
        return this.lastFailedAttempt;
    }
}

