/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.provider;

import com.aliyun.akless.idprovider.accessor.AccessorProxy;
import com.aliyun.akless.idprovider.daemon.IdpDaemonMonitor;
import com.aliyun.akless.idprovider.enums.TokenSignAlg;
import com.aliyun.akless.idprovider.errors.IdpException;
import com.aliyun.akless.idprovider.model.EnvConfig;
import com.aliyun.akless.idprovider.provider.AklessIDTokenProvider;
import com.aliyun.akless.idprovider.provider.IAklessIDTokenProvider;
import com.aliyun.akless.idprovider.provider.IDProviderEnvConfig;
import com.aliyun.akless.idprovider.utils.JwtUtil;
import lombok.NonNull;

public class AklessIDTokenProviderFactory {
    public static EnvConfig initEnvConfig(IDProviderEnvConfig config) throws IdpException {
        if (config.getBootstrapToken() != null && !config.getBootstrapToken().isEmpty()) {
            JwtUtil.parseEnvConfigFromToken(config.getBootstrapToken(), config.getAppName());
        }
        IdpDaemonMonitor.keepMonitorAlive();
        return AccessorProxy.getAccessor().initEnvConfig(config.getRegionId(), config.getNamespace(), config.getAppName(), config.getAppGroup(), config.getAppEnv(), config.getBootstrapToken());
    }

    public static EnvConfig initEnvConfig(@NonNull String regionId, @NonNull String appName, @NonNull String appGroup, @NonNull String appEnv, @NonNull String bootstrapToken) throws IdpException {
        if (regionId == null) {
            throw new NullPointerException("regionId is marked non-null but is null");
        }
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        if (appGroup == null) {
            throw new NullPointerException("appGroup is marked non-null but is null");
        }
        if (appEnv == null) {
            throw new NullPointerException("appEnv is marked non-null but is null");
        }
        if (bootstrapToken == null) {
            throw new NullPointerException("bootstrapToken is marked non-null but is null");
        }
        IDProviderEnvConfig config = new IDProviderEnvConfig();
        config.setRegionId(regionId);
        config.setNamespace("aone");
        config.setAppName(appName);
        config.setAppGroup(appGroup);
        config.setAppEnv(appEnv);
        config.setBootstrapToken(bootstrapToken);
        return AklessIDTokenProviderFactory.initEnvConfig(config);
    }

    public static EnvConfig initEnvConfig(@NonNull String regionId, @NonNull String appName, @NonNull String appGroup, @NonNull String appEnv) throws IdpException {
        if (regionId == null) {
            throw new NullPointerException("regionId is marked non-null but is null");
        }
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        if (appGroup == null) {
            throw new NullPointerException("appGroup is marked non-null but is null");
        }
        if (appEnv == null) {
            throw new NullPointerException("appEnv is marked non-null but is null");
        }
        return AklessIDTokenProviderFactory.initEnvConfig(regionId, appName, appGroup, appEnv, "");
    }

    public static EnvConfig initEnvConfig(@NonNull String regionId, @NonNull String appName) throws IdpException {
        if (regionId == null) {
            throw new NullPointerException("regionId is marked non-null but is null");
        }
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        return AklessIDTokenProviderFactory.initEnvConfig(regionId, appName, "", "");
    }

    public static EnvConfig initEnvConfig(@NonNull String appName) throws IdpException {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        return AklessIDTokenProviderFactory.initEnvConfig("", appName);
    }

    public static IAklessIDTokenProvider getRSAProvider() throws IdpException {
        return new AklessIDTokenProvider("aliyun-oidc-sts", TokenSignAlg.SIGN_ALG_RSA);
    }

    public static IAklessIDTokenProvider getHMACProvider() throws IdpException {
        return new AklessIDTokenProvider("aliyun-oidc-sts", TokenSignAlg.SIGN_ALG_HMAC);
    }
}

