/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.provider;

import com.aliyun.akless.idprovider.enums.TokenCredType;
import com.aliyun.akless.idprovider.enums.TokenSignAlg;
import com.aliyun.akless.idprovider.errors.IdpException;
import com.aliyun.akless.idprovider.model.OIDCToken;
import com.aliyun.akless.idprovider.model.TokenFactor;
import com.aliyun.akless.idprovider.provider.AklessCredentialProvider;
import com.aliyun.akless.idprovider.provider.IAklessIDTokenProvider;
import com.aliyun.akless.idprovider.utils.config.Config;
import java.util.HashSet;
import java.util.Set;

public class AklessIDTokenProvider
extends AklessCredentialProvider
implements IAklessIDTokenProvider {
    private static final Set<TokenFactor> executed = new HashSet<TokenFactor>();
    protected final TokenFactor tokenFactor;

    public AklessIDTokenProvider(String targetService) {
        this(targetService, TokenSignAlg.SIGN_ALG_RSA);
    }

    public AklessIDTokenProvider(String targetService, TokenSignAlg signAlg) {
        this.tokenFactor = new TokenFactor(signAlg, targetService);
        this.checkTokenRetrievalOnce();
    }

    @Override
    public OIDCToken getIDToken() throws IdpException {
        return this.accessorProxy.getIDToken(this.tokenFactor);
    }

    @Override
    public OIDCToken refreshIDToken() throws IdpException {
        return this.accessorProxy.refreshIDToken(this.tokenFactor);
    }

    @Override
    public OIDCToken getIDTokenOnBehalf(TokenCredType sourceCredentialType, String sourceCredential) throws IdpException {
        return this.accessorProxy.getIDTokenOnBehalf(sourceCredentialType, sourceCredential, this.tokenFactor, false);
    }

    @Override
    public OIDCToken getIDTokenOnAssumption(String sourceNamespace, String sourceAppName, String sourceAppGroup, String sourceAppEnv) throws IdpException {
        return this.accessorProxy.getIDTokenOnAssumptionForApp(sourceNamespace, sourceAppName, sourceAppGroup, sourceAppEnv, this.tokenFactor, false);
    }

    @Override
    public OIDCToken getIDTokenOnAssumptionForEmp(String empId) throws IdpException {
        return this.accessorProxy.getIDTokenOnAssumptionForEmp(empId, this.tokenFactor, false);
    }

    protected synchronized void checkTokenRetrievalOnce() throws IdpException {
        if (!executed.contains(this.tokenFactor)) {
            this.accessorProxy.getIDToken(this.tokenFactor, Config.GRPC_FIRST_GET_CREDENTIAL_TIMEOUT_MILLIS);
            executed.add(this.tokenFactor);
        }
    }
}

