/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.model;

import com.aliyun.akless.idprovider.enums.TokenSignAlg;
import java.util.Objects;

public class TokenFactor {
    final TokenSignAlg signAlg;
    final String targetService;
    final int keyHash;

    public TokenFactor(TokenSignAlg signAlg, String targetService) {
        this.signAlg = signAlg;
        this.targetService = targetService;
        this.keyHash = Objects.hash(signAlg.getAlg(), targetService);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TokenFactor)) {
            return false;
        }
        TokenFactor otherFactor = (TokenFactor)other;
        return this.signAlg.getCode().equals(otherFactor.signAlg.getCode()) && this.targetService.equals(otherFactor.targetService);
    }

    public String toString() {
        return String.format("%s:%s", this.signAlg.getAlg(), this.targetService);
    }

    public int hashCode() {
        return this.keyHash;
    }

    public TokenSignAlg getSignAlg() {
        return this.signAlg;
    }

    public String getTargetService() {
        return this.targetService;
    }
}

