/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.errors;

import com.aliyun.akless.idprovider.errors.IdpErrorCode;
import com.aliyun.akless.idprovider.utils.StringUtil;
import java.util.ArrayList;

public class IdpException
extends RuntimeException {
    private static final long serialVersionUID = 3515857435766633780L;
    private String code;
    private String message;
    private String stackTraces;
    private boolean fatal;

    public IdpException(String code, String message) {
        this.stackTraces = IdpException.stackTrace();
        this.code = code;
        this.message = message;
    }

    public IdpException(IdpErrorCode errorResult, Object ... vars) {
        this.stackTraces = IdpException.stackTrace();
        this.code = errorResult.name();
        this.message = String.format(errorResult.message, vars);
        this.fatal = errorResult.isFatal();
    }

    private static String stackTrace() {
        ArrayList<StackTraceElement> stackTraces = new ArrayList<StackTraceElement>(20);
        for (StackTraceElement stackTraceElement : new Throwable().getStackTrace()) {
            stackTraces.add(stackTraceElement);
            if (stackTraces.size() >= 20) break;
        }
        return "\n\t" + StringUtil.join(stackTraces, "\n\t");
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getStackTraces() {
        return this.stackTraces;
    }

    public boolean isFatal() {
        return this.fatal;
    }

    public IdpException() {
    }
}

