/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.daemon;

import com.aliyun.akless.idprovider.daemon.BaseDaemonLauncher;
import com.aliyun.akless.idprovider.errors.IdpErrorCode;
import com.aliyun.akless.idprovider.errors.IdpException;
import com.aliyun.akless.idprovider.utils.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;

public class WindowsDaemonLauncher
extends BaseDaemonLauncher {
    @Override
    public void preExecute() throws Exception {
    }

    @Override
    public void postExecute() {
    }

    @Override
    protected File generateExecutable() throws Exception {
        File targetBin = null;
        try (InputStream in = null;){
            String srcBinPath = "/bin/windows/x64/idp-server";
            in = WindowsDaemonLauncher.class.getResourceAsStream(srcBinPath);
            if (in == null) {
                throw new IdpException(IdpErrorCode.LAUNCH_IDP_SERVER_FAILED, "idp-server binary not found in package");
            }
            String ext = ".exe";
            targetBin = new File(Paths.get(FileUtil.getAndMakeBinDir(), "idp-server" + ext).toString());
            targetBin.delete();
            Files.copy(in, targetBin.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return targetBin;
    }

    @Override
    protected void forkNewDaemon(String daemonPath, List<String> args, Map<String, String> envp) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(args.toArray(new String[0]));
        Process process = processBuilder.start();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            StringBuilder errorMessage = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    errorMessage.append(line).append(System.lineSeparator());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IdpException(IdpErrorCode.LAUNCH_IDP_SERVER_FAILED, String.format("unknown exit code %d and error message: %s", exitCode, errorMessage));
        }
    }
}

