/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.daemon;

import com.aliyun.akless.idprovider.daemon.BaseDaemonLauncher;
import com.aliyun.akless.idprovider.daemon.clib.CLibrary;
import com.aliyun.akless.idprovider.daemon.clib.OSConstants;
import com.aliyun.akless.idprovider.errors.IdpErrorCode;
import com.aliyun.akless.idprovider.errors.IdpException;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.Retryer;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.RetryerBuilder;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.StopStrategies;
import com.aliyun.akless.idprovider.shaded.com.github.rholder.retry.WaitStrategies;
import com.aliyun.akless.idprovider.utils.ExceptionUtil;
import com.aliyun.akless.idprovider.utils.FileUtil;
import com.aliyun.akless.idprovider.utils.config.Config;
import com.sun.jna.Native;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixDaemonLauncher
extends BaseDaemonLauncher {
    private static final Logger logger = LoggerFactory.getLogger(UnixDaemonLauncher.class);
    private static final String startLock = ".akless_idp.start";
    private static final String serverFlag = ".akless_idp.proc";
    private static final Retryer<Integer> daemonLockRetryer = RetryerBuilder.newBuilder().retryIfResult(result -> result == -1 && Native.getLastError() == OSConstants.EWOULDBLOCK).withStopStrategy(StopStrategies.stopAfterDelay(Config.DAEMON_LOCK_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS)).withWaitStrategy(WaitStrategies.fixedWait(100L, TimeUnit.MILLISECONDS)).build();
    private int startLockFd = -1;
    private int lifecycleLockFd = -1;

    @Override
    public void preExecute() throws Exception {
        this.acquireStartLock();
        try {
            this.releaseServerFlag();
            this.acquireServerFlag();
            this.daemonSelfManage = true;
        }
        catch (Exception e) {
            this.daemonSelfManage = false;
            logger.warn("idp daemon won't self-manage its life cycle: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void postExecute() {
        this.releaseStartLock();
    }

    @Override
    protected File generateExecutable() throws Exception {
        File targetBin = null;
        try (InputStream in = null;){
            String binDir;
            String osName = System.getProperty("os.name").toLowerCase();
            String osArch = System.getProperty("os.arch").toLowerCase();
            if (osName.contains("linux")) {
                binDir = osArch.contains("arm") || osArch.contains("aarch") ? "/bin/linux/aarch64" : "/bin/linux/x64";
            } else if (osName.contains("mac")) {
                binDir = osArch.contains("arm") || osArch.contains("aarch") ? "/bin/darwin/aarch64" : "/bin/darwin/x64";
            } else {
                throw new IdpException(IdpErrorCode.UNSUPPORTED_PLATFORM, osName);
            }
            Path srcBinPath = Paths.get(binDir, "idp-server");
            in = UnixDaemonLauncher.class.getResourceAsStream(srcBinPath.toString());
            if (in == null) {
                throw new IdpException(IdpErrorCode.LAUNCH_IDP_SERVER_FAILED, "idp-server binary not found in package");
            }
            targetBin = new File(Paths.get(FileUtil.getAndMakeBinDir(), "idp-server").toString());
            targetBin.delete();
            Files.copy(in, targetBin.toPath(), StandardCopyOption.REPLACE_EXISTING);
            EnumSet<PosixFilePermission[]> permissions = EnumSet.of(PosixFilePermission.OWNER_READ, new PosixFilePermission[]{PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE});
            Files.setPosixFilePermissions(targetBin.toPath(), permissions);
        }
        return targetBin;
    }

    @Override
    protected void forkNewDaemon(String daemonPath, List<String> args, Map<String, String> envp) throws Exception {
        int[] bootstrapPid = new int[1];
        int[] status = new int[1];
        args.addAll(Arrays.asList("-p", String.valueOf(CLibrary.LIBC.getpid())));
        String[] envs = (String[])envp.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toArray(String[]::new);
        int retCode = CLibrary.LIBC.posix_spawn(bootstrapPid, daemonPath, null, null, args.toArray(new String[0]), envs);
        if (retCode != 0 || CLibrary.LIBC.waitpid(bootstrapPid[0], status, 0) < 0) {
            String errMsg = CLibrary.LIBC.strerror(Native.getLastError());
            logger.error("failed to fork idp-server: {}", (Object)errMsg);
            throw new IdpException(IdpErrorCode.LAUNCH_IDP_SERVER_FAILED, errMsg);
        }
        if (!CLibrary.WIFEXITED(status[0])) {
            throw new IdpException(IdpErrorCode.LAUNCH_IDP_SERVER_FAILED, "idp-server not terminate normally");
        }
        int exitCode = CLibrary.WEXITSTATUS(status[0]);
        if (exitCode != 0) {
            IdpDaemonExitCode code = IdpDaemonExitCode.valueOf(exitCode);
            if (code == null) {
                throw new IdpException(IdpErrorCode.LAUNCH_IDP_SERVER_FAILED, String.format("unknown exit code: %d", exitCode));
            }
            switch (code) {
                case DAEMONIZE_ERROR: {
                    throw new IdpException(IdpErrorCode.DAEMONIZE_IDP_SERVER_FAILED, new Object[0]);
                }
                case SPAWN_UDS_LISTENER_ERROR: {
                    throw new IdpException(IdpErrorCode.SPAWN_UDS_LISTENER_FAILED, new Object[0]);
                }
                case SPAWN_UDS_WATCHER_ERROR: {
                    throw new IdpException(IdpErrorCode.SPAWN_UDS_WATCHER_FAILED, new Object[0]);
                }
            }
        }
    }

    private void acquireStartLock() throws IdpException {
        this.startLockFd = UnixDaemonLauncher.acquireFlock(startLock, OSConstants.LOCK_EX | OSConstants.LOCK_NB);
    }

    private void releaseStartLock() {
        UnixDaemonLauncher.releaseFlock(this.startLockFd);
        this.startLockFd = -1;
    }

    private void acquireServerFlag() throws IdpException {
        this.lifecycleLockFd = UnixDaemonLauncher.acquireFlock(serverFlag, OSConstants.LOCK_SH | OSConstants.LOCK_NB);
    }

    private void releaseServerFlag() {
        UnixDaemonLauncher.releaseFlock(this.lifecycleLockFd);
        this.lifecycleLockFd = -1;
    }

    private static int acquireFlock(String fileName, int operation) throws IdpException {
        int fd = -1;
        try {
            String errMsg;
            Path filePath = Paths.get(FileUtil.getAndMakeBinDir(), fileName);
            fd = CLibrary.LIBC.open(filePath.toString(), OSConstants.O_RDONLY | OSConstants.O_CREAT, 292);
            if (fd == -1) {
                throw new IdpException(IdpErrorCode.LAUNCH_IDP_SERVER_FAILED, String.format("unable to create flock fd against %s: %s", filePath, CLibrary.LIBC.strerror(Native.getLastError())));
            }
            try {
                Set<PosixFilePermission> perms = PosixFilePermissions.fromString("r--r--r--");
                Files.setPosixFilePermissions(filePath, perms);
            }
            catch (IOException e) {
                logger.warn(String.format("unable to change file permission against %s: %s", filePath, e.getMessage()));
            }
            try {
                int finalFd = fd;
                int res = daemonLockRetryer.call(() -> CLibrary.LIBC.flock(finalFd, operation));
                if (res == 0) {
                    return fd;
                }
                errMsg = String.format("flock error with code %d", res);
            }
            catch (Exception e) {
                errMsg = ExceptionUtil.normalizeRetryException(e).getMessage();
            }
            throw new IdpException(IdpErrorCode.LAUNCH_IDP_SERVER_FAILED, String.format("unable to perform flock against %s: %s", filePath, errMsg));
        }
        catch (Exception e) {
            if (fd >= 0) {
                CLibrary.LIBC.close(fd);
            }
            throw e;
        }
    }

    private static void releaseFlock(int lockFd) {
        if (lockFd < 0) {
            return;
        }
        CLibrary.LIBC.flock(lockFd, OSConstants.LOCK_UN);
        CLibrary.LIBC.close(lockFd);
    }

    static enum IdpDaemonExitCode {
        SUCCESS(0),
        GENERIC_ERROR(1),
        DAEMONIZE_ERROR(2),
        GENERATE_BIN_DIR_ERROR(3),
        SPAWN_UDS_LISTENER_ERROR(4),
        SPAWN_UDS_WATCHER_ERROR(5);

        private final int code;
        private static final Map<Integer, IdpDaemonExitCode> codeMap;

        private IdpDaemonExitCode(int code) {
            this.code = code;
        }

        public static IdpDaemonExitCode valueOf(Integer code) {
            return codeMap.get(code);
        }

        static {
            codeMap = new HashMap<Integer, IdpDaemonExitCode>();
            for (IdpDaemonExitCode valueEnum : IdpDaemonExitCode.values()) {
                codeMap.put(valueEnum.code, valueEnum);
            }
        }
    }
}

