/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.idprovider.daemon;

import com.aliyun.akless.idprovider.accessor.AccessorProxy;
import com.aliyun.akless.idprovider.daemon.IdpDaemonManager;
import com.aliyun.akless.idprovider.daemon.IdpTaskScheduler;
import com.aliyun.akless.idprovider.errors.IdpErrorCode;
import com.aliyun.akless.idprovider.errors.IdpException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpDaemonMonitor {
    private static final Logger logger = LoggerFactory.getLogger(IdpDaemonMonitor.class);
    private static final boolean monitorRequired = !AccessorProxy.inPod() && System.getenv("AKLESS_IDP_NO_DAEMON") == null;
    private static Thread monitorThread;
    private static final AtomicBoolean monitorStateNormal;
    private static final Object mutex;
    private static final IdpDaemonManager daemonManager;
    private static final IdpTaskScheduler taskScheduler;
    private static final int maxDaemonSuccessiveFailureCnt = 5;

    private static void start() throws IdpException {
        try {
            daemonManager.restart();
        }
        catch (IdpException e) {
            logger.error("failed to start idp server: {}", (Object)e.toString());
            if (e.isFatal()) {
                throw e;
            }
        }
        catch (Exception e) {
            logger.error("failed to start idp server: {}", (Object)e.toString());
        }
        taskScheduler.run();
        monitorThread = new Thread(() -> {
            int daemonSuccessiveFailureCnt = 0;
            while (true) {
                boolean onError = false;
                try {
                    taskScheduler.waitForError();
                    daemonManager.restart();
                    logger.info("check health failure, and succeed to reset...");
                }
                catch (Exception e) {
                    logger.error("failed to restart idp server: {}", (Object)e.toString());
                    onError = true;
                }
                if (onError) {
                    if (daemonSuccessiveFailureCnt++ >= 5) {
                        break;
                    }
                } else {
                    daemonSuccessiveFailureCnt = 0;
                }
                taskScheduler.resume(!onError);
            }
            monitorStateNormal.set(false);
            taskScheduler.shutdown();
        });
        monitorThread.setDaemon(true);
        monitorThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(taskScheduler::shutdown));
    }

    private static boolean isThreadAlive() {
        return monitorThread != null && monitorThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void keepMonitorAlive() throws IdpException {
        if (!monitorRequired) {
            return;
        }
        if (!monitorStateNormal.get()) {
            throw new IdpException(IdpErrorCode.LAUNCH_IDP_SERVER_FAILED, "incompatible environment and idp is no longer able to retrieve idtoken");
        }
        Object object = mutex;
        synchronized (object) {
            if (!IdpDaemonMonitor.isThreadAlive()) {
                IdpDaemonMonitor.start();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        IdpDaemonMonitor.keepMonitorAlive();
        Thread.sleep(60000L);
        System.out.println("finish...");
    }

    static {
        monitorStateNormal = new AtomicBoolean(true);
        mutex = new Object();
        daemonManager = new IdpDaemonManager();
        taskScheduler = new IdpTaskScheduler();
    }
}

