/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.emr.convert;

import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.convert.DefaultNodeConvert;
import com.aliyun.migration.workflow.migration.common.type.EmrWorkflowNodeType;
import com.workflow.migration.transform.dw.converter.dsv3.convert.ConditionsNodeConvert;
import com.workflow.migration.transform.dw.converter.dsv3.convert.DataxNodeConvert;
import com.workflow.migration.transform.dw.converter.dsv3.convert.DependentNodeConvert;
import com.workflow.migration.transform.dw.converter.dsv3.convert.Dolphin3ConvertFactory;
import com.workflow.migration.transform.dw.converter.dsv3.convert.Dolphin3FileConvert;
import com.workflow.migration.transform.dw.converter.dsv3.convert.HiveCliNodeConvert;
import com.workflow.migration.transform.dw.converter.dsv3.convert.HttpNodeConvert;
import com.workflow.migration.transform.dw.converter.dsv3.convert.MrNodeConvert;
import com.workflow.migration.transform.dw.converter.dsv3.convert.ProcedureNodeConvert;
import com.workflow.migration.transform.dw.converter.dsv3.convert.PythonNodeConvert;
import com.workflow.migration.transform.dw.converter.dsv3.convert.SeatunnelNodeConvert;
import com.workflow.migration.transform.dw.converter.dsv3.convert.ShellNodeConvert;
import com.workflow.migration.transform.dw.converter.dsv3.convert.SqoopNodeConvert;
import com.workflow.migration.transform.dw.converter.dsv3.convert.SubProcessNodeConvert;
import com.workflow.migration.transform.dw.converter.dsv3.convert.SwitchNodeConvert;
import com.workflow.migration.transform.dw.converter.emr.convert.node.ImpalaShellNodeConvert;
import com.workflow.migration.transform.dw.converter.emr.convert.node.RemoteShellNodeConvert;
import com.workflow.migration.transform.dw.converter.emr.convert.node.SparkNodeConvert;
import com.workflow.migration.transform.dw.converter.emr.convert.node.SqlNodeConvert;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmrWorkflowConvertFactory
extends Dolphin3ConvertFactory {
    private static final Logger log = LoggerFactory.getLogger(EmrWorkflowConvertFactory.class);

    private EmrWorkflowNodeType getTaskType(String taskTypeStr) {
        try {
            return EmrWorkflowNodeType.of((String)taskTypeStr);
        }
        catch (Exception e) {
            log.error("get taskType error");
            return null;
        }
    }

    public AbstractConvert<List<WorkflowNode>> getNodeListConvert(String taskTypeStr, TaskContext taskContext, Workflow workflow) {
        EmrWorkflowNodeType taskType = this.getTaskType(taskTypeStr);
        if (taskType == null) {
            log.warn("not supported thie tasktype {}, use default convert", (Object)taskTypeStr);
            return new DefaultNodeConvert(taskContext, workflow);
        }
        switch (taskType) {
            case IMPALASHELL: {
                return new ImpalaShellNodeConvert(taskContext, workflow);
            }
            case REMOTESHELL: {
                return new RemoteShellNodeConvert(taskContext, workflow);
            }
            case PROCEDURE: {
                return new ProcedureNodeConvert(taskContext, workflow);
            }
            case SQL: {
                return new SqlNodeConvert(taskContext, workflow);
            }
            case PYTHON: {
                return new PythonNodeConvert(taskContext, workflow);
            }
            case CONDITIONS: {
                return new ConditionsNodeConvert(taskContext, workflow);
            }
            case SUB_PROCESS: {
                return new SubProcessNodeConvert(taskContext, workflow);
            }
            case DEPENDENT: {
                return new DependentNodeConvert(taskContext, workflow);
            }
            case SHELL: {
                return new ShellNodeConvert(taskContext, workflow);
            }
            case SWITCH: {
                return new SwitchNodeConvert(taskContext, workflow);
            }
            case HTTP: {
                return new HttpNodeConvert(taskContext, workflow);
            }
            case SPARK: {
                return new SparkNodeConvert(taskContext, workflow);
            }
            case MR: {
                return new MrNodeConvert(taskContext, workflow);
            }
            case HIVECLI: {
                return new HiveCliNodeConvert(taskContext, workflow);
            }
            case DATAX: {
                return new DataxNodeConvert(taskContext, workflow);
            }
            case SQOOP: {
                return new SqoopNodeConvert(taskContext, workflow);
            }
            case SEATUNNEL: {
                return new SeatunnelNodeConvert(taskContext, workflow);
            }
        }
        return new DefaultNodeConvert(taskContext, workflow);
    }

    public AbstractConvert<WorkflowFileResource> getFileConvert(TaskContext taskContext) {
        return new Dolphin3FileConvert(taskContext);
    }
}

