/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.reader.adf;

import com.aliyun.migrationx.common.http.HttpClientUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.ZipUtils;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdfReader {
    private static final Logger log = LoggerFactory.getLogger(AdfReader.class);
    private static final String PIPELINE = "pipelines";
    private static final String TRIGGER = "triggers";
    private static final String LINKED_SERVICE = "linked_services";
    private static final String JSON_SUFFIX = ".json";
    private final String subscriptionId;
    private final String resourceGroupName;
    private final String token;
    private final String factory;
    private final File exportFile;

    public AdfReader(String token, String subscriptionId, String resourceGroupName, String factory, File exportFile) {
        this.subscriptionId = subscriptionId;
        this.resourceGroupName = resourceGroupName;
        this.factory = factory;
        this.token = token;
        this.exportFile = exportFile;
    }

    public File export() throws Exception {
        File parent = new File(this.exportFile.getParentFile(), StringUtils.split((String)this.exportFile.getName(), (String)".")[0]);
        if (!parent.exists() && !parent.mkdirs()) {
            log.error("failed create file directory for: {}", (Object)this.exportFile);
            return null;
        }
        log.info("workspace directory: {}", (Object)parent);
        File tmpDir = new File(parent, ".tmp");
        if (tmpDir.exists()) {
            FileUtils.deleteDirectory((File)tmpDir);
        }
        this.doExport(tmpDir);
        if (this.exportFile.getName().endsWith("zip")) {
            return this.doPackage(tmpDir, this.exportFile);
        }
        return tmpDir;
    }

    private void doExport(File tmpDir) throws Exception {
        this.exportPipelines(tmpDir);
        this.exportTriggers(tmpDir);
        this.exportLinkedServices(tmpDir);
    }

    public File doPackage(File tmpDir, File exportFile) throws IOException {
        return ZipUtils.zipDir((File)tmpDir, (File)exportFile);
    }

    private void exportLinkedServices(File factoryDir) throws Exception {
        File curFactory = new File(factoryDir, this.factory);
        List<JsonObject> linkedServices = this.listLinkedServices();
        if (CollectionUtils.isNotEmpty(linkedServices)) {
            FileUtils.writeStringToFile((File)new File(curFactory, "linked_services.json"), (String)GsonUtils.toJsonString(linkedServices), (Charset)StandardCharsets.UTF_8);
        }
    }

    public void exportPipelines(File factoryDir) throws Exception {
        File curFactory = new File(factoryDir, this.factory);
        List<JsonObject> pipelines = this.listPipelines();
        if (CollectionUtils.isNotEmpty(pipelines)) {
            FileUtils.writeStringToFile((File)new File(curFactory, "pipelines.json"), (String)GsonUtils.toJsonString(pipelines), (Charset)StandardCharsets.UTF_8);
        }
    }

    public void exportTriggers(File factoryDir) throws Exception {
        File curFactory = new File(factoryDir, this.factory);
        List<JsonObject> pipelines = this.listTriggers();
        if (CollectionUtils.isNotEmpty(pipelines)) {
            FileUtils.writeStringToFile((File)new File(curFactory, "triggers.json"), (String)GsonUtils.toJsonString(pipelines), (Charset)StandardCharsets.UTF_8);
        }
    }

    public List<JsonObject> listPipelines() throws Exception {
        String url = MessageFormat.format("https://management.azure.com/subscriptions/{0}/resourceGroups/{1}/providers/Microsoft.DataFactory/factories/{2}/pipelines?api-version=2018-06-01", this.subscriptionId, this.resourceGroupName, this.factory);
        JsonObject jsonObject = (JsonObject)GsonUtils.fromJsonString((String)AdfReader.executeGet(url, this.token), (Type)new TypeToken<JsonObject>(){}.getType());
        JsonArray jsonArray = jsonObject.get("value").getAsJsonArray();
        return (List)GsonUtils.gson.fromJson((JsonElement)jsonArray, new TypeToken<List<JsonObject>>(){}.getType());
    }

    public List<JsonObject> listTriggers() throws Exception {
        String url = MessageFormat.format("https://management.azure.com/subscriptions/{0}/resourceGroups/{1}/providers/Microsoft.DataFactory/factories/{2}/triggers?api-version=2018-06-01", this.subscriptionId, this.resourceGroupName, this.factory);
        JsonObject jsonObject = (JsonObject)GsonUtils.fromJsonString((String)AdfReader.executeGet(url, this.token), (Type)new TypeToken<JsonObject>(){}.getType());
        JsonArray jsonArray = jsonObject.get("value").getAsJsonArray();
        return (List)GsonUtils.gson.fromJson((JsonElement)jsonArray, new TypeToken<List<JsonObject>>(){}.getType());
    }

    public List<JsonObject> listLinkedServices() throws Exception {
        String url = MessageFormat.format("https://management.azure.com/subscriptions/{0}/resourceGroups/{1}/providers/Microsoft.DataFactory/factories/{2}/linkedservices?api-version=2018-06-01", this.subscriptionId, this.resourceGroupName, this.factory);
        JsonObject jsonObject = (JsonObject)GsonUtils.fromJsonString((String)AdfReader.executeGet(url, this.token), (Type)new TypeToken<JsonObject>(){}.getType());
        JsonArray jsonArray = jsonObject.get("value").getAsJsonArray();
        return (List)GsonUtils.gson.fromJson((JsonElement)jsonArray, new TypeToken<List<JsonObject>>(){}.getType());
    }

    private static String executeGet(String url, String token) throws Exception {
        HttpClientUtil client = new HttpClientUtil();
        HttpGet httpGet = new HttpGet();
        httpGet.setHeader("Authorization", "Bearer " + token);
        httpGet.setURI(new URI(url));
        return client.executeAndGet((HttpRequestBase)httpGet);
    }
}

