/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiDatasourceMappingConfig;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.AbstractWedataDIConverter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.converter.WedataDIConvertFactory;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.domain.IntegrationNodeInfo;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.di.domain.WeDataDISpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WedataDIScriptConverter {
    private static final Logger log = LoggerFactory.getLogger(WedataDIScriptConverter.class);
    private DiDatasourceMappingConfig convertConfigs;
    private List<WorkflowDatasource> datasourceList;
    List<DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping> srcDsMappings;
    List<DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping> destDsMappings;

    public WedataDIScriptConverter(DiDatasourceMappingConfig convertConfigs, List<WorkflowDatasource> datasourceList) {
        this.convertConfigs = convertConfigs;
        this.datasourceList = datasourceList;
        this.srcDsMappings = new ArrayList<DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping>();
        this.destDsMappings = new ArrayList<DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping>();
    }

    public String getConnectDatasource() {
        StringBuilder sb = new StringBuilder();
        if (!this.srcDsMappings.isEmpty()) {
            this.srcDsMappings.forEach(datasource -> sb.append(datasource.getTgtName()).append(" "));
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(", ");
        if (!this.destDsMappings.isEmpty()) {
            this.destDsMappings.forEach(datasource -> sb.append(datasource.getTgtName()).append(" "));
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String getConnectDatasourceType() {
        StringBuilder sb = new StringBuilder();
        if (!this.srcDsMappings.isEmpty()) {
            this.srcDsMappings.forEach(datasource -> sb.append(datasource.getTgtType()).append(" "));
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(", ");
        if (!this.destDsMappings.isEmpty()) {
            this.destDsMappings.forEach(datasource -> sb.append(datasource.getTgtType()).append(" "));
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String convert(String jsonStr) {
        JSONObject writer;
        JSONObject reader;
        DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping convertConfig;
        WorkflowDatasource tgtDatasource;
        WeDataDISpec weDataDISpec;
        try {
            weDataDISpec = WeDataDISpec.getWeDataDISpec(jsonStr);
        }
        catch (Exception e) {
            log.error("DI\u89e3\u6790\u5931\u8d25\uff0c\u5728dataworks\u4e2d\u586b\u5145\u7a7a\u6a21\u7248");
            return this.getEmptyTemplate();
        }
        if (weDataDISpec.getInputNode() == null || weDataDISpec.getOutputNode() == null) {
            log.warn("\u6570\u636e\u96c6\u6210\u811a\u672c\u5185\u5bb9\u4e3a\u7a7a\uff0c\u5728dataworks\u4e2d\u586b\u5145\u7a7a\u6a21\u7248");
            return this.getEmptyTemplate();
        }
        ArrayList<WorkflowDatasource> srcDatasources = new ArrayList<WorkflowDatasource>();
        ArrayList<WorkflowDatasource> tgtDatasources = new ArrayList<WorkflowDatasource>();
        WorkflowDatasource srcDatasource = this.findDatasourceById(weDataDISpec.getInputNode().getDatasourceId(), weDataDISpec.getInputNode().getDataSourceType());
        if (srcDatasource != null) {
            srcDatasources.add(srcDatasource);
        }
        if ((tgtDatasource = this.findDatasourceById(weDataDISpec.getOutputNode().getDatasourceId(), weDataDISpec.getOutputNode().getDataSourceType())) != null) {
            tgtDatasources.add(tgtDatasource);
        }
        try {
            JSONArray.parseArray((String)weDataDISpec.getInputNode().getConfig().get("SiblingNodes"), (JSONReader.Feature[])new JSONReader.Feature[0]).forEach(node -> {
                WorkflowDatasource subSrcDatasourceId = this.findDatasourceById(((JSONObject)node).getString("DatasourceId"), weDataDISpec.getInputNode().getDataSourceType());
                if (subSrcDatasourceId != null) {
                    srcDatasources.add(subSrcDatasourceId);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (WorkflowDatasource datasource : srcDatasources) {
            convertConfig = this.getConvertConfig(weDataDISpec.getInputNode(), datasource);
            this.srcDsMappings.add(convertConfig);
        }
        for (WorkflowDatasource datasource : tgtDatasources) {
            convertConfig = this.getConvertConfig(weDataDISpec.getOutputNode(), datasource);
            this.destDsMappings.add(convertConfig);
        }
        if (this.srcDsMappings.isEmpty() || this.destDsMappings.isEmpty()) {
            return null;
        }
        WedataDIConvertFactory converFactory = new WedataDIConvertFactory();
        AbstractWedataDIConverter readerConverter = converFactory.getReaderConverter(this.srcDsMappings.get(0));
        AbstractWedataDIConverter writerConverter = converFactory.getWriterConverter(this.destDsMappings.get(0));
        if (weDataDISpec.getInputNode() == null || weDataDISpec.getOutputNode() == null) {
            reader = JSONObject.parseObject((String)"{\n            \"stepType\":\"stream\",\n            \"parameter\":{},\n            \"name\":\"Reader\",\n            \"category\":\"reader\"\n        }");
            writer = JSONObject.parseObject((String)"{\n            \"stepType\":\"stream\",\n            \"parameter\":{},\n            \"name\":\"Writer\",\n            \"category\":\"writer\"\n        }");
            log.warn("\u6570\u636e\u96c6\u6210\u811a\u672c\u5185\u5bb9\u4e3a\u7a7a\uff0c\u5728dataworks\u4e2d\u586b\u5145\u7a7a\u6a21\u7248");
        } else {
            reader = readerConverter != null ? readerConverter.convert(weDataDISpec.getInputNode(), weDataDISpec.getOutputNode().getNodeMapping(), this.srcDsMappings, srcDatasources) : JSONObject.parseObject((String)"{\n            \"stepType\":\"stream\",\n            \"parameter\":{},\n            \"name\":\"Reader\",\n            \"category\":\"reader\"\n        }");
            writer = writerConverter != null ? writerConverter.convert(weDataDISpec.getOutputNode(), weDataDISpec.getOutputNode().getNodeMapping(), this.destDsMappings, tgtDatasources) : JSONObject.parseObject((String)"{\n            \"stepType\":\"stream\",\n            \"parameter\":{},\n            \"name\":\"Writer\",\n            \"category\":\"writer\"\n        }");
        }
        JSONArray steps = new JSONArray(new Object[]{reader, writer});
        JSONObject result = JSONObject.parse((String)"{\n    \"type\":\"job\",\n    \"version\":\"2.0\",\n    \"steps\":[],\n    \"setting\":{\n        \"errorLimit\":{\n            \"record\":\"0\"\n        },\n        \"speed\":{\n            \"throttle\":true,\n            \"concurrent\":1,\n            \"mbps\":\"12\"\n        }\n    },\n    \"order\":{\n        \"hops\":[\n            {\n                \"from\":\"Reader\",\n                \"to\":\"Writer\"\n            }\n        ]\n    }\n}", (JSONReader.Feature[])new JSONReader.Feature[0]);
        result.put((Object)"steps", (Object)steps);
        return result.toJSONString(new JSONWriter.Feature[0]);
    }

    public DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping getConvertConfig(IntegrationNodeInfo integrationNodeInfo, WorkflowDatasource datasource) {
        String datasourceName = datasource.getName();
        String datasourceId = datasource.getDatasourceId();
        String datasourceType = datasource.getType();
        String datasourceDb = null;
        if (integrationNodeInfo != null && integrationNodeInfo.getConfig() != null) {
            datasourceDb = integrationNodeInfo.getConfig().get("Database");
        }
        DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping convertConfig = this.convertConfigs.getConnectionMapping(datasourceName, datasourceDb, datasourceId, datasourceType, null);
        return convertConfig;
    }

    private WorkflowDatasource findDatasourceById(String id, String datasourceType) {
        Object workflowDatasource;
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        if (this.datasourceList != null && !this.datasourceList.isEmpty() && ((Optional)(workflowDatasource = this.datasourceList.stream().filter(ds -> ds.getDatasourceId().equals(id)).findFirst())).isPresent()) {
            return (WorkflowDatasource)((Optional)workflowDatasource).get();
        }
        workflowDatasource = new WorkflowDatasource();
        workflowDatasource.setDatasourceId(id);
        workflowDatasource.setType(datasourceType);
        return workflowDatasource;
    }

    private String getEmptyTemplate() {
        JSONObject reader = JSONObject.parseObject((String)"{\n            \"stepType\":\"stream\",\n            \"parameter\":{},\n            \"name\":\"Reader\",\n            \"category\":\"reader\"\n        }");
        JSONObject writer = JSONObject.parseObject((String)"{\n            \"stepType\":\"stream\",\n            \"parameter\":{},\n            \"name\":\"Writer\",\n            \"category\":\"writer\"\n        }");
        JSONArray steps = new JSONArray(new Object[]{reader, writer});
        JSONObject result = JSONObject.parse((String)"{\n    \"type\":\"job\",\n    \"version\":\"2.0\",\n    \"steps\":[],\n    \"setting\":{\n        \"errorLimit\":{\n            \"record\":\"0\"\n        },\n        \"speed\":{\n            \"throttle\":true,\n            \"concurrent\":1,\n            \"mbps\":\"12\"\n        }\n    },\n    \"order\":{\n        \"hops\":[\n            {\n                \"from\":\"Reader\",\n                \"to\":\"Writer\"\n            }\n        ]\n    }\n}", (JSONReader.Feature[])new JSONReader.Feature[0]);
        result.put((Object)"steps", (Object)steps);
        return result.toJSONString(new JSONWriter.Feature[0]);
    }
}

