/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.wedata.convert.node;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonNodeConverter
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(PythonNodeConverter.class);

    public PythonNodeConverter(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return tgtNodes;
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        if (Objects.isNull(workflowNode.getCustomProperties())) {
            workflowNode.setCustomProperties(new HashMap());
        }
        if (Objects.isNull(tgtworkflowNode.getCustomProperties())) {
            tgtworkflowNode.setCustomProperties(new HashMap());
        }
        String codeProgramType = this.getNodeType(workflowNode);
        tgtworkflowNode.setNodeType(codeProgramType);
        CodeProgramType tgtNodeType = this.getCodeProgramType(codeProgramType);
        if (tgtNodeType == null) {
            log.warn("illegal node type: {}", (Object)codeProgramType);
        } else {
            String imageId = null;
            switch (tgtNodeType.getCalcEngineType()) {
                case EMR: {
                    if (tgtNodeType.equals((Object)CodeProgramType.EMR_SHELL)) {
                        String tempScriptName = tgtworkflowNode.getNodeName() + "_" + tgtworkflowNode.getNodeId() + "_script.py";
                        String pythonScript = tgtworkflowNode.getScript();
                        String shellScript = "#!/bin/bash\n\n# \u5b9a\u4e49Python\u4ee3\u7801\nPYTHON_CODE='''\\\n" + pythonScript + "'''\n\n# \u5c06Python\u4ee3\u7801\u4fdd\u5b58\u5230\u6587\u4ef6\u4e2d\necho \"$PYTHON_CODE\" > " + tempScriptName + "\n\n# \u8fd0\u884cPython\u811a\u672c\npython " + tempScriptName + "\nrm -f " + tempScriptName;
                        tgtworkflowNode.setScript(shellScript);
                    }
                    tgtworkflowNode.setScript(PythonNodeConverter.wfToEmrCode((WorkflowNode)tgtworkflowNode));
                    break;
                }
                case ODPS: {
                    if (tgtNodeType.equals((Object)CodeProgramType.PYODPS3)) {
                        imageId = this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.pyodps3ImageId", null);
                        break;
                    }
                    if (!tgtNodeType.equals((Object)CodeProgramType.PYODPS)) break;
                    imageId = this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.pyodps2ImageId", null);
                    break;
                }
                case HOLO: {
                    break;
                }
                case GENERAL: {
                    if (!tgtNodeType.equals((Object)CodeProgramType.PYTHON)) break;
                    imageId = this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.pythonImageId", null);
                }
            }
            if (imageId != null) {
                tgtworkflowNode.getCustomProperties().put("resource.group.image.id", imageId);
            }
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        return this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.pythonNodeType", CodeProgramType.PYTHON.name());
    }
}

