/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.wedata.convert.node;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.AbstractSqlNodeConverter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSqlNodeConverter
extends AbstractSqlNodeConverter {
    private static final Logger log = LoggerFactory.getLogger(JdbcSqlNodeConverter.class);
    private static String defaultType = CodeProgramType.MYSQL.name();

    public JdbcSqlNodeConverter(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
    }

    @Override
    protected String getNodeType(WorkflowNode workflowNode) {
        Map nodeConfMap = this.getNodeConfMap(workflowNode);
        Object orDefault = ((Map)Optional.ofNullable(nodeConfMap).orElse(new HashMap())).getOrDefault("workflow.converter.jdbcSqlNodeType", null);
        if (orDefault instanceof JSONObject) {
            JSONObject jsonObject = orDefault;
            String targetNodeType = jsonObject.getString(workflowNode.getDbType());
            if (StringUtils.isNotBlank((String)targetNodeType)) {
                if (Arrays.stream(CodeProgramType.values()).collect(Collectors.toMap(Enum::name, CodeProgramType::getCalcEngineType)).containsKey(targetNodeType)) {
                    return targetNodeType;
                }
                log.warn("\u672a\u7ed9JDBC SQL - {}\u914d\u7f6e\u8f6c\u6362\u89c4\u5219\uff0c\u8282\u70b9{}\u88ab\u9ed8\u8ba4\u8f6c\u6362\u4e3a{}", new Object[]{workflowNode.getDbType(), workflowNode.getNodeName(), defaultType});
            }
        } else if (orDefault instanceof String) {
            return orDefault;
        }
        log.warn("\u672a\u7ed9JDBC SQL - {}\u914d\u7f6e\u8f6c\u6362\u89c4\u5219\uff0c\u8282\u70b9{}\u88ab\u9ed8\u8ba4\u8f6c\u6362\u4e3a{}", new Object[]{workflowNode.getDbType(), workflowNode.getNodeName(), defaultType});
        return defaultType;
    }
}

