/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.wedata.convert;

import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowProject;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvert;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvertFactory;
import com.aliyun.migration.workflow.migration.common.convert.ProjectConvert;
import com.workflow.migration.transform.dw.converter.wedata.convert.Wedata2DwWorkflowConverter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.DefaultNodeConverter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.ForeachEndNodeConverter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.ForeachNodeConverter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.ForeachStartNodeConverter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.HiveSqlNodeConverter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.JdbcSqlNodeConverter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.OfflineSyncNodeConverter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.PythonNodeConverter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.ShellNodeConverter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.SparkPyNodeConverter;
import com.workflow.migration.transform.dw.converter.wedata.convert.node.SparkSqlNodeConverter;
import com.workflow.migration.transform.dw.converter.wedata.enums.WedataNodeType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wedata2DwConvertFactory
extends AbstractConvertFactory {
    private static final Logger log = LoggerFactory.getLogger(Wedata2DwConvertFactory.class);

    public AbstractConvert<WorkflowProject> getProjectConvert(TaskContext taskContext) {
        return new ProjectConvert(taskContext);
    }

    public AbstractConvert<Workflow> getWorkflowConvert(TaskContext taskContext) {
        return new Wedata2DwWorkflowConverter(taskContext);
    }

    public AbstractConvert<List<WorkflowNode>> getNodeListConvert(String taskType, TaskContext taskContext, Workflow workflow) {
        WedataNodeType wedataNodeType = WedataNodeType.getTypeByName(taskType);
        switch (wedataNodeType) {
            case SHELL: {
                return new ShellNodeConverter(taskContext, workflow);
            }
            case PYTHON: {
                return new PythonNodeConverter(taskContext, workflow);
            }
            case JDBC_SQL: {
                return new JdbcSqlNodeConverter(taskContext, workflow);
            }
            case HIVE_SQL: {
                return new HiveSqlNodeConverter(taskContext, workflow);
            }
            case SPARK_SQL: {
                return new SparkSqlNodeConverter(taskContext, workflow);
            }
            case OFFLINE_SYNC: {
                return new OfflineSyncNodeConverter(taskContext, workflow);
            }
            case SPARK_PY: {
                return new SparkPyNodeConverter(taskContext, workflow);
            }
            case FOREACH: {
                return new ForeachNodeConverter(taskContext, workflow);
            }
            case FOREACH_START: {
                return new ForeachStartNodeConverter(taskContext, workflow);
            }
            case FOREACH_END: {
                return new ForeachEndNodeConverter(taskContext, workflow);
            }
            case CUSTOM: {
                log.warn("cannot recognize taskType:{}, convert as VIRTUAL node", (Object)taskType);
                return new DefaultNodeConverter(taskContext, workflow);
            }
        }
        log.warn("not found convert for taskType:{}, convert as VIRTUAL node", (Object)taskType);
        return new DefaultNodeConverter(taskContext, workflow);
    }
}

