/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.dsv1.module;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.DolphinSchedulerPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.TaskDefinition;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.DataWorksPackage;
import com.aliyun.dataworks.migrationx.domain.dataworks.standard.objects.Package;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksDolphinSchedulerTransformer;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksTransformerConfig;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.plugin.Converter;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.DataworksMxConverter;
import com.aliyun.migration.workflow.migration.common.convert.AbstractConvertFactory;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.context.TransformerContext;
import com.aliyun.migrationx.common.metrics.enums.CollectorType;
import com.workflow.migration.transform.dw.dsv1.convert.DolphinV1ConvertFactory;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinV12DwConverter
extends DataworksMxConverter {
    private static final Logger log = LoggerFactory.getLogger(DolphinV12DwConverter.class);

    public AbstractConvertFactory getConvertFactory() {
        return new DolphinV1ConvertFactory();
    }

    public Converter init(TaskContext taskContext) throws IOException {
        super.init(taskContext);
        TransformerContext.init((CollectorType)CollectorType.DolphinScheduler);
        return this;
    }

    protected WorkflowNode getCustomWorkflowNode(WorkflowNode originNode) {
        String originScript = originNode.getOriginScript();
        WorkflowNode workflowNode = new WorkflowNode();
        workflowNode.setWorkflowName(originNode.getWorkflowName());
        workflowNode.setWorkflowId(originNode.getWorkflowId());
        workflowNode.setNodeName(originNode.getNodeName());
        TaskDefinition taskDefinition = (TaskDefinition)BwmJsonUtil.parseObject((String)originScript, TaskDefinition.class);
        if (Objects.nonNull(taskDefinition)) {
            workflowNode.setNodeType(taskDefinition.getTaskType());
            workflowNode.setScript(taskDefinition.getTaskParams());
            workflowNode.setPriority(Integer.valueOf(taskDefinition.getTaskGroupPriority()));
        }
        return workflowNode;
    }

    protected DataWorksDolphinSchedulerTransformer createTransformer(File config, Package from, Package to) {
        DolphinSchedulerPackage dolphinSchedulerPackage = (DolphinSchedulerPackage)from;
        DataWorksTransformerConfig dataWorksTransformerConfig = new DataWorksTransformerConfig();
        DataWorksPackage dataWorksPackage = (DataWorksPackage)to;
        try {
            String mxConfigStr = FileUtils.readFileToString((File)config, (String)"UTF-8");
            dataWorksTransformerConfig = (DataWorksTransformerConfig)JSONObject.parseObject((String)mxConfigStr, DataWorksTransformerConfig.class);
        }
        catch (Exception e) {
            log.error("createTransformer error", (Throwable)e);
        }
        return new DataWorksDolphinSchedulerTransformer(dataWorksTransformerConfig, dolphinSchedulerPackage, dataWorksPackage);
    }

    protected DataWorksPackage convertUseMxTransform(String mxConfigFilePath, String sourceFilePath, String targetFilePath) {
        DolphinSchedulerPackage fromPackage = new DolphinSchedulerPackage();
        fromPackage.setPackageFile(new File(new File(sourceFilePath).getAbsolutePath()));
        DataWorksPackage toPackage = new DataWorksPackage();
        toPackage.setPackageFile(new File(targetFilePath));
        DataWorksDolphinSchedulerTransformer transformer = this.createTransformer(new File(mxConfigFilePath), (Package)fromPackage, (Package)toPackage);
        transformer.init();
        transformer.load();
        transformer.transform();
        return (DataWorksPackage)transformer.getTargetPackage();
    }

    public void close() {
        super.close();
        TransformerContext.clear();
    }
}

