/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.dsv1.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.subprocess.SubProcessParameters;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.RelationPackage;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migration.workflow.migration.common.utils.TopoSortUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubProcessNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(SubProcessNodeConvert.class);

    public SubProcessNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        SubProcessParameters parameter = (SubProcessParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(SubProcessParameters.class).getType());
        long processDefinitionCode = parameter.getProcessDefinitionId().intValue();
        List workflowList = this.taskContext.getWorkflowProjectPackage().getWorkflowList();
        List dependWorkflowList = ListUtils.emptyIfNull((List)workflowList).stream().filter(x -> x.getWorkflowId().equalsIgnoreCase(String.valueOf(processDefinitionCode))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(dependWorkflowList)) {
            Workflow dependWorkflow = (Workflow)dependWorkflowList.get(0);
            List dependWorkflowWorkflowNodes = dependWorkflow.getWorkflowNodes();
            List simpleNodes = TopoSortUtil.getSimpleNodes((List)dependWorkflowWorkflowNodes);
            List res = TopoSortUtil.topologicalSort((List)simpleNodes, (boolean)true);
            if (CollectionUtils.isNotEmpty((Collection)res)) {
                List rootBwmNodes = (List)res.get(0);
                List floorBwmNodes = (List)res.get(res.size() - 1);
                WorkflowNode startNode = new WorkflowNode();
                startNode.setNodeType(CodeProgramType.VIRTUAL.name());
                startNode.setNodeName(Joiner.on((String)"_").join((Object)workflowNode.getNodeName(), (Object)this.workflow.getWorkflowId(), new Object[]{"start"}));
                startNode.setNodeId(startNode.getNodeName());
                if (CollectionUtils.isEmpty((Collection)this.workflow.getNodeRelations())) {
                    this.workflow.setNodeRelations(new ArrayList());
                }
                List parentNodeIds = this.getParentNodeIds(workflowNode);
                ListUtils.emptyIfNull((List)parentNodeIds).forEach(x -> this.workflow.getNodeRelations().add(new RelationPackage(x, startNode.getNodeId(), RelationPackage.ReType.NODE)));
                if (CollectionUtils.isEmpty((Collection)dependWorkflow.getNodeRelations())) {
                    dependWorkflow.setNodeRelations(new ArrayList());
                }
                ListUtils.emptyIfNull((List)rootBwmNodes).forEach(x -> dependWorkflow.getNodeRelations().add(new RelationPackage(startNode.getNodeId(), x.getId(), RelationPackage.ReType.NODE)));
                WorkflowNode endNode = new WorkflowNode();
                endNode.setNodeType(CodeProgramType.VIRTUAL.name());
                endNode.setNodeName(Joiner.on((String)"_").join((Object)workflowNode.getNodeName(), (Object)this.workflow.getWorkflowId(), new Object[]{"end"}));
                endNode.setNodeId(endNode.getNodeName());
                ListUtils.emptyIfNull((List)floorBwmNodes).forEach(x -> this.workflow.getNodeRelations().add(new RelationPackage(x.getId(), endNode.getNodeId(), RelationPackage.ReType.NODE)));
                List childrenNodeIds = this.getChildrenNodeIds(workflowNode);
                ListUtils.emptyIfNull((List)childrenNodeIds).forEach(x -> this.workflow.getNodeRelations().add(new RelationPackage(endNode.getNodeId(), x, RelationPackage.ReType.NODE)));
                this.supplyBaseMsg(startNode);
                this.supplyBaseMsg(endNode);
                tgtNodes.add(startNode);
                tgtNodes.add(endNode);
            }
        } else {
            tgtworkflowNode.setNodeType(CodeProgramType.VIRTUAL.getName());
            this.supplyBaseMsg(tgtworkflowNode);
            tgtNodes.add(tgtworkflowNode);
        }
        return tgtNodes;
    }
}

