/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.dsv1.convert;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.sql.SqlParameters;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(SqlNodeConvert.class);

    public SqlNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        if (Objects.isNull(workflowNode.getCustomProperties())) {
            workflowNode.setCustomProperties(new HashMap());
        }
        tgtworkflowNode.setNodeType(this.getNodeType(workflowNode));
        String codeProgramType = this.getDbType(workflowNode);
        tgtworkflowNode.setDbType(codeProgramType);
        this.chooseDataSource(workflowNode, tgtworkflowNode, codeProgramType);
        if (codeProgramType.equals(CodeProgramType.ODPS_SQL.name())) {
            tgtworkflowNode.setNodeType(CodeProgramType.ODPS_SQL.name());
        } else if (CodeProgramType.EMR_HIVE.name().equals(codeProgramType) || CodeProgramType.EMR_SPARK.name().equals(codeProgramType) || CodeProgramType.EMR_SPARK_SQL.name().equals(codeProgramType) || CodeProgramType.EMR_IMPALA.name().equals(codeProgramType) || CodeProgramType.EMR_KYUUBI.name().equals(codeProgramType) || CodeProgramType.EMR_PRESTO.name().equals(codeProgramType)) {
            tgtworkflowNode.setScript(SqlNodeConvert.wfToEmrCode((WorkflowNode)tgtworkflowNode));
            tgtworkflowNode.setNodeType(codeProgramType);
        } else if (codeProgramType.equals(CodeProgramType.MYSQL.name()) || codeProgramType.equals(CodeProgramType.SQLSERVER.name()) || codeProgramType.equals(CodeProgramType.Oracle.name()) || codeProgramType.equals(CodeProgramType.POSTGRESQL.name()) || codeProgramType.equals(CodeProgramType.StarRocks.name()) || codeProgramType.equals(CodeProgramType.DRDS.name()) || codeProgramType.equals(CodeProgramType.Doris.name()) || codeProgramType.equals(CodeProgramType.Mariadb.name()) || codeProgramType.equals(CodeProgramType.Selectdb.name()) || codeProgramType.equals(CodeProgramType.Redshift.name()) || codeProgramType.equals(CodeProgramType.Saphana.name()) || codeProgramType.equals(CodeProgramType.Vertica.name()) || codeProgramType.equals(CodeProgramType.OceanBase.name()) || codeProgramType.equals(CodeProgramType.DB2.name()) || codeProgramType.equals(CodeProgramType.ADB_for_PostgreSQL.name()) || codeProgramType.equals(CodeProgramType.ADB_for_MySQL.name())) {
            tgtworkflowNode.setNodeType(codeProgramType);
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    private void chooseDataSource(WorkflowNode workflowNode, WorkflowNode tgtworkflowNode, String codeProgramType) {
        try {
            String sqlParamStr = workflowNode.getCustomProperties().getOrDefault("SQL_PARAM", "").toString();
            if (StringUtils.isNotBlank((String)sqlParamStr)) {
                SqlParameters parameter = (SqlParameters)GsonUtils.fromJsonString((String)sqlParamStr, (Type)TypeToken.get(SqlParameters.class).getType());
                tgtworkflowNode.setDatasourceId(this.getConnectionName(parameter, codeProgramType, tgtworkflowNode));
            }
        }
        catch (Exception e) {
            log.error("chooseDataSource error {} {}", new Object[]{workflowNode.getWorkflowName(), workflowNode.getNodeName(), e});
        }
    }

    private String getConnectionName(SqlParameters parameter, String codeProgramType, WorkflowNode workflowNode) {
        Map nodeConfMap = this.getNodeConfMap(workflowNode);
        String mappingJson = nodeConfMap.getOrDefault("workflow.converter.connection.mapping", "{}");
        if (StringUtils.isNotEmpty((String)mappingJson)) {
            Map connectionMapping = (Map)JSONUtils.parseObject((String)mappingJson, Map.class);
            if (connectionMapping == null) {
                log.error("parse connection mapping with {} error", (Object)mappingJson);
            } else {
                String connectionName = (String)connectionMapping.get(codeProgramType);
                log.info("Got connectionName {} by {}", (Object)connectionName, (Object)codeProgramType);
                return connectionName;
            }
        }
        if (!CodeProgramType.EMR_HIVE.name().equals(codeProgramType) && !CodeProgramType.EMR_SPARK.name().equals(codeProgramType)) {
            List workflowDatasources = this.taskContext.getWorkflowDatasources();
            if (parameter.getDatasource() > 0) {
                return CollectionUtils.emptyIfNull((Collection)workflowDatasources).stream().filter(s -> s.getDatasourceId().equalsIgnoreCase(String.valueOf(parameter.getDatasource()))).findFirst().map(WorkflowDatasource::getName).orElseGet(null);
            }
        }
        return null;
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        return CodeProgramType.SQL_COMPONENT.name();
    }

    private String getDbType(WorkflowNode workflowNode) {
        JSONObject jsonObject;
        String dbType;
        Map nodeConfMap = this.getNodeConfMap(workflowNode);
        String orDefault = ((Map)Optional.ofNullable(nodeConfMap).orElse(new HashMap())).getOrDefault("workflow.converter.dolphinscheduler.sqlNodeTypeMapping", CodeProgramType.SQL_COMPONENT.name());
        if (orDefault instanceof JSONObject && StringUtils.isNotBlank((String)(dbType = (jsonObject = (JSONObject)orDefault).getString(workflowNode.getDbType().toUpperCase(Locale.ROOT))))) {
            return dbType;
        }
        return CodeProgramType.MYSQL.name();
    }
}

