/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.dsv1.convert;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.OdpsSparkCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.SparkArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.entity.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.ResourceUtils;
import com.aliyun.dataworks.migrationx.transformer.core.spark.command.SparkSubmitCommandBuilder;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.temp.SparkParameters;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class SparkNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(SparkNodeConvert.class);

    public SparkNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            return tgtNodes;
        }
        SparkParameters sparkParam = (SparkParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(SparkParameters.class).getType());
        com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.spark.SparkParameters parameter = sparkParam.toMxParameters();
        List allFileResources = this.getAllFileResources();
        ListUtils.emptyIfNull((List)Optional.ofNullable(parameter).map(com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.spark.SparkParameters::getResourceFilesList).orElse(ListUtils.emptyIfNull(null))).forEach(res -> ListUtils.emptyIfNull((List)allFileResources).stream().filter(res1 -> Objects.equals(res1.getId(), res.getId())).forEach(res1 -> {
            BeanUtils.copyProperties((Object)res1, (Object)res);
            res.setRes(res1.getName());
            res.setName(res1.getName());
        }));
        tgtworkflowNode.setNodeType(this.getNodeType(workflowNode));
        if (Objects.isNull(tgtworkflowNode.getParamMap())) {
            tgtworkflowNode.setParamMap(new HashMap());
        }
        ListUtils.emptyIfNull((List)parameter.getLocalParams()).stream().forEach(x -> tgtworkflowNode.getParamMap().put(x.getProp(), x.getValue()));
        List resources = ListUtils.emptyIfNull((List)parameter.getResourceFilesList()).stream().filter(Objects::nonNull).map(ResourceInfo::getName).distinct().collect(Collectors.toList());
        ArrayList<String> codeLines = new ArrayList<String>();
        codeLines.add(DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.valueOf((String)tgtworkflowNode.getNodeType()), (String)"", resources));
        String sparkCmd = Joiner.on((String)" ").join((Iterable)SparkArgsUtils.buildArgs((com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.v139.task.spark.SparkParameters)parameter).stream().map(String::valueOf).collect(Collectors.toList()));
        tgtworkflowNode.setScript(sparkCmd);
        this.convertSparkSubmit(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        log.info("node: {}, spark command: {}", (Object)tgtworkflowNode.getNodeName(), (Object)sparkCmd);
        return tgtNodes;
    }

    private void convertSparkSubmit(WorkflowNode tgtWorkflowNode) {
        CodeProgramType defaultNodeType = CodeProgramType.valueOf((String)tgtWorkflowNode.getNodeType());
        log.info("node type: {}", (Object)defaultNodeType);
        switch (defaultNodeType) {
            case ODPS_SPARK: {
                this.convertToOdpsSpark(tgtWorkflowNode);
                break;
            }
            case EMR_SPARK: 
            case CDH_SPARK: {
                this.convertToSpark(tgtWorkflowNode, defaultNodeType.getCalcEngineType().name());
                tgtWorkflowNode.setNodeType(defaultNodeType.name());
            }
        }
    }

    private void convertToOdpsSpark(WorkflowNode tgtWorkflowNode) {
        SparkSubmitCommandBuilder sparkSubmitCommandBuilder = this.getSparkSubmitCommandBuilder(tgtWorkflowNode);
        String calcEngineType = "odps";
        List<String> appResources = this.handleResources(this.workflow, Arrays.asList(sparkSubmitCommandBuilder.getAppResource()), calcEngineType);
        String main = ListUtils.emptyIfNull(appResources).stream().findFirst().orElse("");
        List jars = this.handleResources(this.workflow, sparkSubmitCommandBuilder.getJars(), calcEngineType).stream().filter(str -> str.endsWith("jar")).collect(Collectors.toList());
        List assistFiles = this.handleResources(this.workflow, sparkSubmitCommandBuilder.getFiles(), calcEngineType).stream().filter(str -> str.split("\\.").length == 1).collect(Collectors.toList());
        List pyFiles = this.handleResources(this.workflow, sparkSubmitCommandBuilder.getPyFiles(), calcEngineType).stream().filter(str -> str.endsWith("py")).collect(Collectors.toList());
        List assistArchives = this.handleResources(this.workflow, sparkSubmitCommandBuilder.getFiles(), calcEngineType).stream().filter(str -> str.split("\\.").length == 2 && ResourceUtils.FILE_EXT_ARCHIVE.contains(str.split("\\.")[1].toLowerCase())).collect(Collectors.toList());
        OdpsSparkCode odpsSparkCode = new OdpsSparkCode();
        ArrayList<String> referenceResources = new ArrayList<String>();
        referenceResources.add(main);
        referenceResources.addAll(this.handleResources(this.workflow, sparkSubmitCommandBuilder.getJars(), calcEngineType));
        odpsSparkCode.setResourceReferences(referenceResources);
        OdpsSparkCode.CodeJson sparkJson = new OdpsSparkCode.CodeJson();
        sparkJson.setArgs(Joiner.on((String)" ").join((Iterable)sparkSubmitCommandBuilder.getAppArgs()));
        sparkJson.setAssistFiles(assistFiles);
        sparkJson.setAssistJars(jars);
        sparkJson.setAssistPys(pyFiles);
        sparkJson.setAssistArchives(assistArchives);
        sparkJson.setArchivesName(assistArchives);
        sparkJson.setMainClass(sparkSubmitCommandBuilder.getMainClass());
        if (main.endsWith("jar")) {
            sparkJson.setMainJar(main);
            sparkJson.setLanguage("java");
        }
        if (main.endsWith("py")) {
            sparkJson.setMainPy(main);
            sparkJson.setLanguage("python");
        }
        sparkSubmitCommandBuilder.getConf().put("spark.hadoop.odps.task.major.version", "cupid_v2");
        sparkJson.setConfigs(sparkSubmitCommandBuilder.getConf().entrySet().stream().map(ent -> Joiner.on((String)"=").join(ent.getKey(), ent.getValue(), new Object[0])).collect(Collectors.toList()));
        odpsSparkCode.setSparkJson(sparkJson);
        tgtWorkflowNode.setScript(odpsSparkCode.toString());
        tgtWorkflowNode.setNodeType(CodeProgramType.ODPS_SPARK.name());
    }

    private SparkSubmitCommandBuilder getSparkSubmitCommandBuilder(WorkflowNode node) {
        List args = new ArrayList(Arrays.asList(node.getScript().split(" ")).stream().filter(str -> str.trim().length() > 0).map(String::trim).collect(Collectors.toList()));
        args = args.subList(1, args.size());
        try {
            SparkSubmitCommandBuilder sparkSubmitCommandBuilder = new SparkSubmitCommandBuilder(args);
            return sparkSubmitCommandBuilder;
        }
        catch (Exception e) {
            log.warn("code: {}, exception: ", (Object)node.getScript(), (Object)e);
            return null;
        }
    }

    private void convertToSpark(WorkflowNode tgtWorkflowNode, String calcEngineType) {
        SparkSubmitCommandBuilder sparkSubmitCommandBuilder = this.getSparkSubmitCommandBuilder(tgtWorkflowNode);
        if (sparkSubmitCommandBuilder == null) {
            return;
        }
        List<String> appResources = this.handleResources(this.workflow, Arrays.asList(sparkSubmitCommandBuilder.getAppResource()), calcEngineType);
        List jars = this.handleResources(this.workflow, sparkSubmitCommandBuilder.getJars(), calcEngineType).stream().filter(str -> str.endsWith("jar")).collect(Collectors.toList());
        List assistFiles = this.handleResources(this.workflow, sparkSubmitCommandBuilder.getFiles(), calcEngineType).stream().filter(str -> str.split("\\.").length == 1).collect(Collectors.toList());
        List pyFiles = this.handleResources(this.workflow, sparkSubmitCommandBuilder.getPyFiles(), calcEngineType).stream().filter(str -> str.endsWith("py")).collect(Collectors.toList());
        List assistArchives = this.handleResources(this.workflow, sparkSubmitCommandBuilder.getFiles(), calcEngineType).stream().filter(str -> str.split("\\.").length == 2 && ResourceUtils.FILE_EXT_ARCHIVE.contains(str.split("\\.")[1].toLowerCase())).collect(Collectors.toList());
        ArrayList<String> referenceResources = new ArrayList<String>();
        referenceResources.addAll(appResources);
        referenceResources.addAll(jars);
        referenceResources.addAll(assistFiles);
        referenceResources.addAll(pyFiles);
        referenceResources.addAll(assistArchives);
        String resReferenceCode = referenceResources.stream().map(res -> "##@resource_reference{\"" + res + "\"}").collect(Collectors.joining("\n"));
        referenceResources.stream().forEach(res -> {
            String code = Arrays.stream(StringUtils.split((String)tgtWorkflowNode.getScript(), (String)" ")).map(arg -> arg.contains((CharSequence)res) ? res : arg).collect(Collectors.joining(" "));
            tgtWorkflowNode.setScript(code);
        });
        tgtWorkflowNode.setScript(Joiner.on((String)"\n").join((Object)resReferenceCode, (Object)tgtWorkflowNode.getScript(), new Object[0]).trim());
    }

    private List<String> handleResources(Workflow workflow, List<String> files, String calcEngineType) {
        if (workflow == null || CollectionUtils.isEmpty(files)) {
            return Collections.emptyList();
        }
        List resources = CollectionUtils.isEmpty((Collection)workflow.getFiles()) ? new ArrayList() : workflow.getFiles();
        List resourceNames = resources.stream().map(WorkflowFileResource::getName).collect(Collectors.toList());
        List<String> fileNames = files.stream().map(file -> new File((String)file).getName()).collect(Collectors.toList());
        fileNames.stream().filter(fileName -> !resourceNames.contains(fileName)).forEach(fileName -> this.addPlaceholderResource(workflow, (String)fileName, calcEngineType));
        return fileNames;
    }

    private void addPlaceholderResource(Workflow workflow, String fileName, String calcEngineType) {
        WorkflowFileResource resource = new WorkflowFileResource();
        resource.setName(fileName);
        resource.setFileType(ResourceUtils.getFileResourceType((String)fileName, (String)calcEngineType));
        String filePath = ResourceUtils.getPlaceholderFile((String)fileName);
        resource.setPath(filePath);
        if (workflow.getFiles() != null) {
            workflow.getFiles().add(resource);
        }
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        return this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.sparkSubmitAs", CodeProgramType.EMR_SPARK.name());
    }
}

