/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.core.nacos.utils;

import com.alibaba.nacos.common.codec.Base64;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SpasAdapter {
    private static final String TIMESTAMP_HEADER = "Timestamp";
    private static final String SIGNATURE_HEADER = "Spas-Signature";
    private static final String GROUP_KEY = "group";
    public static final String TENANT_KEY = "tenant";
    private static final String SHA_ENCRYPT = "HmacSHA1";

    public static Map<String, String> getSignHeaders(String resource, String secretKey) {
        HashMap<String, String> header = new HashMap<String, String>(2);
        String timeStamp = String.valueOf(System.currentTimeMillis());
        header.put(TIMESTAMP_HEADER, timeStamp);
        if (secretKey != null) {
            String signature = StringUtils.isBlank((CharSequence)resource) ? SpasAdapter.signWithHmacSha1Encrypt(timeStamp, secretKey) : SpasAdapter.signWithHmacSha1Encrypt(resource + "+" + timeStamp, secretKey);
            header.put(SIGNATURE_HEADER, signature);
        }
        return header;
    }

    public static String signWithHmacSha1Encrypt(String encryptText, String encryptKey) {
        try {
            byte[] data = encryptKey.getBytes("UTF-8");
            SecretKeySpec secretKey = new SecretKeySpec(data, SHA_ENCRYPT);
            Mac mac = Mac.getInstance(SHA_ENCRYPT);
            mac.init(secretKey);
            byte[] text = encryptText.getBytes("UTF-8");
            byte[] textFinal = mac.doFinal(text);
            return new String(Base64.encodeBase64((byte[])textFinal), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("signWithhmacSHA1Encrypt fail", e);
        }
    }
}

