/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.core.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.plugin.auth.api.LoginIdentityContext;
import com.alibaba.nacos.plugin.auth.api.RequestResource;
import com.alibaba.nacos.plugin.auth.spi.client.AbstractClientAuthService;
import com.aliyun.akless.credprovider.plugin.common.credprovider.AklessCredentialClient;
import com.aliyun.akless.credprovider.plugin.common.error.CredProviderException;
import com.aliyun.akless.credprovider.plugin.core.AklessCredProviderFactory;
import com.aliyun.akless.credprovider.plugin.core.CredentialProviderConfig;
import com.aliyun.akless.credprovider.plugin.core.nacos.injector.AbstractResourceInjector;
import com.aliyun.akless.credprovider.plugin.core.nacos.injector.ConfigResourceInjector;
import com.aliyun.akless.credprovider.plugin.core.nacos.injector.NamingResourceInjector;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosAuthPluginServiceImpl
extends AbstractClientAuthService {
    private static Logger log = LoggerFactory.getLogger(NacosAuthPluginServiceImpl.class);
    private AklessCredentialClient provider = null;
    private final Map<String, AbstractResourceInjector> resourceInjectors = new HashMap<String, AbstractResourceInjector>();

    public NacosAuthPluginServiceImpl() {
        this.resourceInjectors.put("naming", new NamingResourceInjector());
        this.resourceInjectors.put("config", new ConfigResourceInjector());
    }

    public Boolean login(Properties properties) {
        String ramRoleArn = properties.getProperty("AklessRamRoleArn");
        String secretName = properties.getProperty("AklessSecretName");
        String credentialArn = properties.getProperty("AklessCredentialArn");
        if (ramRoleArn == null && secretName == null && credentialArn == null) {
            return Boolean.FALSE;
        }
        try {
            CredentialProviderConfig config = new CredentialProviderConfig();
            config.setRamRoleArn(ramRoleArn);
            config.setSecretName(secretName);
            config.setCredentialArn(credentialArn);
            config.setRegionId(properties.getProperty("AklessRegionId"));
            config.setAppName(properties.getProperty("AklessAppName"));
            config.setAppGroup(properties.getProperty("AklessAppGroup"));
            config.setAppEnv(properties.getProperty("AklessAppEnv"));
            config.setBootstrapToken(properties.getProperty("AklessBootstrapToken"));
            config.setIdToken(properties.getProperty("AklessIDToken"));
            this.provider = AklessCredProviderFactory.getCredentialClient(config);
            return Boolean.TRUE;
        }
        catch (CredProviderException e) {
            log.error("Failed to login akless nacos auth plugin, Error Code: {}, Error Message:{}", new Object[]{e.getCode(), e.getMsg(), e});
            return Boolean.FALSE;
        }
    }

    public LoginIdentityContext getLoginIdentityContext(RequestResource requestResource) {
        LoginIdentityContext result = new LoginIdentityContext();
        if (this.provider == null) {
            return result;
        }
        if (!this.resourceInjectors.containsKey(requestResource.getType())) {
            log.error("Injector for type {} not found, need extra word to support it", (Object)requestResource.getType());
            return result;
        }
        this.resourceInjectors.get(requestResource.getType()).doInject(requestResource, this.provider.getCredential(), result);
        return result;
    }

    public void shutdown() throws NacosException {
    }
}

