/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.core.credmgr;

import com.aliyun.akless.credprovider.plugin.common.Constants;
import com.aliyun.akless.credprovider.plugin.common.cred.AklessCredentials;
import com.aliyun.akless.credprovider.plugin.common.enums.NetworkEnvMode;
import com.aliyun.akless.credprovider.plugin.common.environment.AklessEnv;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogCode;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogMessageKeys;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogger;
import com.aliyun.akless.credprovider.plugin.common.utils.ExceptionUtils;
import com.aliyun.akless.credprovider.plugin.common.utils.IDTokenUtils;
import com.aliyun.akless.credprovider.plugin.core.credmgr.CredentialManager;
import com.aliyun.akless.credprovider.plugin.core.credmgr.IDTokenCredentialManager;
import com.aliyun.credentials.Client;
import com.aliyun.kms20160120.models.GetSecretValueRequest;
import com.aliyun.kms20160120.models.GetSecretValueResponse;
import com.aliyun.tea.TeaException;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDTokenSecretCredentialManager
implements CredentialManager {
    protected AklessCredentials credentials;
    protected String secretName;
    private String idToken;
    private String primaryInnerKmsEndpoint;
    private String backupInnerKmsEndpoint;
    private Map<String, Object> messageLog = new HashMap<String, Object>();
    protected Map<String, String> secretInfoLog = new HashMap<String, String>();
    private Config kmsConfig;
    protected Throwable lastError;
    protected Logger log = LoggerFactory.getLogger(IDTokenSecretCredentialManager.class);

    public IDTokenSecretCredentialManager(String secretName) throws Exception {
        this.secretName = secretName;
        this.secretInfoLog.put(EventLogMessageKeys.SecretName.getValue(), secretName);
        try {
            this.idToken = IDTokenCredentialManager.getIdToken("inner-kms", this.secretInfoLog);
        }
        catch (Exception e) {
            if (StringUtils.isBlank((CharSequence)AklessEnv.getIdToken())) {
                throw e;
            }
            this.idToken = AklessEnv.getIdToken();
        }
        try {
            this.secretInfoLog.put(EventLogMessageKeys.IdTokenJTI.getValue(), IDTokenUtils.getTokenJti(this.idToken));
        }
        catch (Exception e) {
            this.secretInfoLog.put(EventLogMessageKeys.IdTokenJTI.getValue(), "unknown");
        }
        if (AklessEnv.isInVPC()) {
            this.primaryInnerKmsEndpoint = String.format("innerkms-%s-vpc.aliyun-inc.com", AklessEnv.getRegionId());
            this.backupInnerKmsEndpoint = String.format("innerkms-%s-vpc-backup.aliyun-inc.com", AklessEnv.getRegionId());
        } else if (AklessEnv.isInOXS()) {
            if (AklessEnv.isDomestic()) {
                this.primaryInnerKmsEndpoint = "innerkms-cn-hangzhou.aliyun-inc.com";
                this.backupInnerKmsEndpoint = "innerkms-cn-zhangjiakou.aliyun-inc.com";
            } else {
                this.primaryInnerKmsEndpoint = "innerkms-ap-southeast-1.aliyun-inc.com";
                this.backupInnerKmsEndpoint = "innerkms-eu-central-1.aliyun-inc.com";
            }
        } else if (AklessEnv.isInTanneiProduction() || AklessEnv.getNetworkEnv() == NetworkEnvMode.ALIYUN_TEST) {
            this.primaryInnerKmsEndpoint = "innerkms-cn-hangzhou-share.aliyun-inc.com";
            this.backupInnerKmsEndpoint = "innerkms-cn-zhangjiakou-share.aliyun-inc.com";
        } else if (AklessEnv.getNetworkEnv() == NetworkEnvMode.IDPT_OXS) {
            this.primaryInnerKmsEndpoint = this.backupInnerKmsEndpoint = String.format("innerkms.%s.%s-inc.com", AklessEnv.getRegionId(), AklessEnv.getBaseDomain());
        } else if (AklessEnv.getNetworkEnv() == NetworkEnvMode.IDPT_VPC) {
            this.primaryInnerKmsEndpoint = this.backupInnerKmsEndpoint = String.format("innerkms-vpc.%s.%s-inc.com", AklessEnv.getRegionId(), AklessEnv.getBaseDomain());
        } else {
            this.backupInnerKmsEndpoint = "innerkms-daily.aliyun-inc.com";
            this.primaryInnerKmsEndpoint = "innerkms-daily.aliyun-inc.com";
        }
        this.messageLog.put(EventLogMessageKeys.InnerKmsEndpoint.getValue(), this.primaryInnerKmsEndpoint);
        this.messageLog.put(EventLogMessageKeys.BackupInnerKmsEndpoint.getValue(), this.backupInnerKmsEndpoint);
        com.aliyun.credentials.models.Config credentialConfig = new com.aliyun.credentials.models.Config();
        credentialConfig.setType("bearer");
        credentialConfig.setBearerToken(this.idToken);
        this.kmsConfig = new Config();
        this.kmsConfig.protocol = "https";
        this.kmsConfig.setConnectTimeout(Integer.valueOf(1000));
        this.kmsConfig.setReadTimeout(Integer.valueOf(1500));
        this.kmsConfig.setCredential(new Client(credentialConfig));
        this.refreshCredentials();
    }

    private boolean shouldErrorOut(Throwable e) {
        return e instanceof TeaException && Arrays.asList(Constants.INNERKMS_ERROR_OUT_CODE).contains(((TeaException)e).getCode());
    }

    protected GetSecretValueResponse getSecretValue() throws Exception {
        this.messageLog.put(EventLogMessageKeys.UsingBackupEndpoint.getValue(), false);
        try {
            return this.internalGetSecretValue(this.primaryInnerKmsEndpoint);
        }
        catch (Exception e) {
            if (!ExceptionUtils.shouldTryBackupEndpoint(e)) {
                throw e;
            }
            this.log.warn("Trying backup InnerKms endpoint [{} -> {}]", (Object)this.primaryInnerKmsEndpoint, (Object)this.backupInnerKmsEndpoint);
            this.messageLog.put(EventLogMessageKeys.UsingBackupEndpoint.getValue(), true);
            EventLogger.send(EventLogCode.InnerKmsFailureUsingBackupEndpoint, this.secretInfoLog, this.messageLog);
            return this.internalGetSecretValue(this.backupInnerKmsEndpoint);
        }
    }

    private GetSecretValueResponse internalGetSecretValue(String innerKmsEndpoint) throws Exception {
        Long timeStart = null;
        GetSecretValueRequest request = new GetSecretValueRequest();
        request.setSecretName(this.secretName);
        RuntimeOptions options = new RuntimeOptions();
        options.setAutoretry(Boolean.valueOf(false));
        this.kmsConfig.setEndpoint(innerKmsEndpoint);
        com.aliyun.kms20160120.Client kmsClient = new com.aliyun.kms20160120.Client(this.kmsConfig);
        GetSecretValueResponse response = null;
        for (int i = 0; i < 3; ++i) {
            try {
                timeStart = System.currentTimeMillis();
                response = kmsClient.getSecretValueWithOptions(request, options);
                this.messageLog.put(EventLogMessageKeys.InnerKmsCostTimeMs.getValue(), System.currentTimeMillis() - timeStart);
                this.lastError = null;
                return response;
            }
            catch (Throwable e) {
                this.lastError = e;
                this.log.error("Failed to call GetSecretValue as: ", e);
                if (e instanceof TeaException) {
                    TeaException te = (TeaException)e;
                    this.messageLog.put(EventLogMessageKeys.InnerKmsErrorCode.getValue(), te.getCode());
                    this.messageLog.put(EventLogMessageKeys.InnerKmsErrorMsg.getValue(), te.getMessage() + te.getData());
                } else {
                    this.messageLog.put(EventLogMessageKeys.InnerKmsErrorCode.getValue(), e.getClass().getSimpleName());
                    this.messageLog.put(EventLogMessageKeys.InnerKmsErrorMsg.getValue(), e.getMessage());
                }
                this.messageLog.put(EventLogMessageKeys.InnerKmsCostTimeMs.getValue(), System.currentTimeMillis() - timeStart);
                EventLogger.send(EventLogCode.InnerKmsFailure, this.secretInfoLog, this.messageLog);
                if (!this.shouldErrorOut(e) && i != 2) continue;
                throw e;
            }
        }
        throw new RuntimeException("This code path should never be reached");
    }

    @Override
    public void refreshCredentials() throws Exception {
        long startTime = System.currentTimeMillis();
        GetSecretValueResponse response = this.getSecretValue();
        this.credentials = AklessCredentials.fromRawSecret(response.getBody().secretData);
        this.log.info("Succeed in getting raw secret credential with secret {}", (Object)this.secretName);
        HashMap<String, Object> logData = new HashMap<String, Object>();
        logData.put(EventLogMessageKeys.RequestID.getValue(), response.getBody().getRequestId());
        logData.put(EventLogMessageKeys.AccessKeyId.getValue(), this.credentials.getAccessKeyId());
        logData.put(EventLogMessageKeys.CredentialsProvisionTime.getValue(), System.currentTimeMillis() - startTime);
        EventLogger.send(EventLogCode.InnerKmsCredProvider, this.secretInfoLog, logData);
    }

    @Override
    public AklessCredentials getCredentials() {
        return this.credentials;
    }

    protected void finalize() {
    }

    public String getPrimaryInnerKmsEndpoint() {
        return this.primaryInnerKmsEndpoint;
    }

    public String getBackupInnerKmsEndpoint() {
        return this.backupInnerKmsEndpoint;
    }

    @Override
    public Throwable getLastError() {
        return this.lastError;
    }
}

