/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.core.credmgr;

import com.aliyun.akless.credprovider.plugin.common.log.EventLogCode;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogMessageKeys;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogger;
import com.aliyun.akless.credprovider.plugin.common.utils.IDTokenUtils;
import com.aliyun.akless.credprovider.plugin.common.utils.StackTraceUtils;
import com.aliyun.akless.idprovider.enums.TokenSignAlg;
import com.aliyun.akless.idprovider.errors.IdpException;
import com.aliyun.akless.idprovider.provider.AklessIDTokenProvider;
import com.aliyun.akless.idprovider.provider.IAklessIDTokenProvider;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDTokenCredentialManager {
    private static IDTokenCredentialManager instance;
    private static Logger log;
    private static Map<String, IAklessIDTokenProvider> idTokenProviderMap;

    public static void setupIdTokenProvider() throws IdpException {
        idTokenProviderMap = new HashMap<String, IAklessIDTokenProvider>();
        idTokenProviderMap.put("aliyun-oidc-sts", (IAklessIDTokenProvider)new AklessIDTokenProvider("aliyun-oidc-sts", TokenSignAlg.SIGN_ALG_RSA));
        idTokenProviderMap.put("inner-kms", (IAklessIDTokenProvider)new AklessIDTokenProvider("inner-kms", TokenSignAlg.SIGN_ALG_RSA));
    }

    private IDTokenCredentialManager() {
    }

    public static String refreshIdTokenWithGivenInvalidToken(String targetService, String invalidIdToken, Map<String, String> cpInfo) {
        HashMap<String, Object> messageLog = new HashMap<String, Object>();
        IAklessIDTokenProvider idTokenProvider = idTokenProviderMap.get(targetService);
        try {
            messageLog.put(EventLogMessageKeys.LastIdTokenJTI.getValue(), IDTokenUtils.getTokenJti(invalidIdToken));
            messageLog.put(EventLogMessageKeys.LastIdTokenValidTime.getValue(), IDTokenUtils.getValidTimeMills(invalidIdToken));
            messageLog.put(EventLogMessageKeys.LastIdTokenRemainTime.getValue(), IDTokenUtils.getRemainValidTimeMills(invalidIdToken));
            messageLog.put(EventLogMessageKeys.LastIdTokenIssuer.getValue(), IDTokenUtils.getIssuer(invalidIdToken));
            messageLog.put(EventLogMessageKeys.LastIdTokenKeyId.getValue(), IDTokenUtils.getKeyId(invalidIdToken));
            String idToken = idTokenProvider.refreshIDToken().getPlainToken();
            log.info("refresh token successfully: {}", (Object)IDTokenUtils.getTokenJti(idToken));
            messageLog.put(EventLogMessageKeys.IdTokenJTI.getValue(), IDTokenUtils.getTokenJti(idToken));
            messageLog.put(EventLogMessageKeys.IdTokenValidTime.getValue(), IDTokenUtils.getValidTimeMills(idToken));
            messageLog.put(EventLogMessageKeys.IdTokenRemainTime.getValue(), IDTokenUtils.getRemainValidTimeMills(idToken));
            messageLog.put(EventLogMessageKeys.IdTokenIssuer.getValue(), IDTokenUtils.getIssuer(idToken));
            messageLog.put(EventLogMessageKeys.IdTokenKeyId.getValue(), IDTokenUtils.getKeyId(idToken));
            EventLogger.send(EventLogCode.IdTokenForceRefresh, cpInfo, messageLog);
            return idToken;
        }
        catch (Exception e) {
            log.error("Failed to force refresh IDToken from idp: {}", (Object)e.toString());
            messageLog.putAll(StackTraceUtils.handleExceptionInfo(e));
            EventLogger.send(EventLogCode.IdTokenForceRefreshFailure, cpInfo, messageLog);
            return invalidIdToken;
        }
    }

    public static String getIdToken(String targetService, Map<String, String> cpInfo) throws Exception {
        if ("test".equals(System.getProperty("AklessCredentialProviderMockEnv"))) {
            return "eyJhbGciOiJSUzI1NiIsImtpZCI6ImNlbnRlci1jbi1oYW5nemhvdS00ZDNlZDJlZC02NmIwLTRiNTUtYWYxOC0yNTkxYjYyYzY3NTMifQ.eyJpc3MiOiJodHRwczovL2FsaXl1bi1hcHAtaWRwLWNlbnRlci1jbi1oYW5nemhvdS5vc3MtY24taGFuZ3pob3UuYWxpeXVuY3MuY29tIiwic3ViIjoiYWxpeXVuLWFrbGVzcy10ZXN0LWFwcDphcHAtZ3JvdXAtb2ZmaWNlLXpldXMtY3JlYXRlZCIsImF1ZCI6InRlc3RpbmciLCJqdGkiOiI2NTcwN2Y3Yy01ZDhiLTQwY2EtYTBiOS0zMTljYWU1ZmRkYTQiLCJpYXQiOjE3MDE2OTg2ODQsIm5iZiI6MTcwMTY5ODY4NCwiZXhwIjoxNzAxODcxNDg0fQ.bxk85ZC2KBUeUdE7wQXpNyeaNyTYzw0SoS8abq-oP3Rl9s98XAWXY-aKIMeiRw89ho6SC9kg6MCQYLK2IBTSW0IPdqOyUfufwxnp9p6PdmD8UhWfdjMFa1Y-kszgbretNMUbGQZpNm5zZF-iy89US_VSz_2UYimQtZEZoYJMzvcJTJDZdQvKigr-pW-8apzPai0Veq5v5sGLBMOvSeYTKe8h97svzxTwLnSWhiNTxtV7lj7wPOxXbkdxbEApyivjgkne8un_ogQ8oTGeg4TmPV9pvFsCnCyl5O30Z5abKYEa29RNzHprYVmrtV-yuxWh4Md94EdiUQkF_eNO1Obo2Q";
        }
        if ("Rollback2InnerKms".equals(System.getProperty("AklessCredentialProviderMockEnv"))) {
            throw new Exception("Mock exception");
        }
        IAklessIDTokenProvider idTokenProvider = idTokenProviderMap.get(targetService);
        try {
            String idToken = idTokenProvider.getIDToken().getPlainToken();
            log.info("get token successfully: {}, token valid time: {}", (Object)IDTokenUtils.getTokenJti(idToken), (Object)IDTokenUtils.getValidTimeMills(idToken));
            return idToken;
        }
        catch (Exception e) {
            log.error("Failed to get IDToken from idp: [{}]", (Object)e.toString());
            EventLogger.send(EventLogCode.IdTokenGenFailure, cpInfo, StackTraceUtils.handleExceptionInfo(e));
            throw e;
        }
    }

    static {
        log = LoggerFactory.getLogger(IDTokenCredentialManager.class);
        instance = new IDTokenCredentialManager();
    }
}

