/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.core;

import com.aliyun.akless.credprovider.plugin.common.credprovider.AklessCredentialClient;
import com.aliyun.akless.credprovider.plugin.common.credprovider.AklessCredentialsProvider;
import com.aliyun.akless.credprovider.plugin.common.credprovider.AklessICredentialProvider;
import com.aliyun.akless.credprovider.plugin.common.credprovider.AklessOpensearchCredentialsProvider;
import com.aliyun.akless.credprovider.plugin.common.credprovider.AklessOssCredentialsProvider;
import com.aliyun.akless.credprovider.plugin.common.credprovider.AklessOtsCredentialsProvider;
import com.aliyun.akless.credprovider.plugin.common.credprovider.AklessSlsCredentialsProvider;
import com.aliyun.akless.credprovider.plugin.common.credprovider.InnerKmsCredentialsProvider;
import com.aliyun.akless.credprovider.plugin.common.credprovider.RawSecretCredentialsProvider;
import com.aliyun.akless.credprovider.plugin.common.environment.AklessEnv;
import com.aliyun.akless.credprovider.plugin.common.error.CredProviderCode;
import com.aliyun.akless.credprovider.plugin.common.error.CredProviderException;
import com.aliyun.akless.credprovider.plugin.core.CredentialProviderConfig;
import com.aliyun.akless.credprovider.plugin.core.Options;
import com.google.common.base.Strings;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AklessCredProviderFactory {
    private static Logger log = LoggerFactory.getLogger(AklessCredProviderFactory.class);
    private static boolean envInitSuccess = false;
    private static final ConcurrentMap<String, Object> credentialsProviderCache = new ConcurrentHashMap<String, Object>();
    public static final Object lock = new Object();

    private AklessCredProviderFactory() {
    }

    private static synchronized void credProviderInit(CredentialProviderConfig config) throws CredProviderException {
        Options options = new Options(config.getIdToken(), config.getBootstrapToken());
        AklessCredProviderFactory.initEnvWithOptions(config.getRegionId(), config.getAppName(), config.getAppGroup(), config.getAppEnv(), options);
    }

    private static void distributeCredentialArn(CredentialProviderConfig config) throws CredProviderException {
        if (StringUtils.isNotBlank((CharSequence)config.getCredentialArn())) {
            if (config.getCredentialArn().startsWith("acs:ram::")) {
                config.setRamRoleArn(config.getCredentialArn());
            } else {
                config.setSecretName(config.getCredentialArn());
            }
        } else {
            config.setCredentialArn(StringUtils.isNotBlank((CharSequence)config.getRamRoleArn()) ? config.getRamRoleArn() : config.getSecretName());
        }
        if (config.getCredentialArn() == null || !config.getCredentialArn().startsWith("acs:ram::") && !config.getCredentialArn().startsWith("itenant_aliyun:default")) {
            throw new CredProviderException(CredProviderCode.ErrInvalidCredentialArn, "the credential arn provided is invalid: " + config.getCredentialArn());
        }
    }

    private static String getCredentialsProviderKey(String type, CredentialProviderConfig config) {
        return type + ":" + config.getCredentialArn() + ":" + String.valueOf(config.getStsTokenDurationSeconds());
    }

    public static void initEnv(String regionId, String appName, String appGroup, String appEnv) throws CredProviderException {
        AklessCredProviderFactory.initEnvWithOptions(regionId, appName, appGroup, appEnv, new Options());
    }

    public static void initEnv(String regionId, String appName) throws CredProviderException {
        AklessCredProviderFactory.initEnvWithOptions(regionId, appName, "", "", new Options());
    }

    public static void initEnv(String appName) throws CredProviderException {
        AklessCredProviderFactory.initEnvWithOptions("", appName, "", "", new Options());
    }

    public static synchronized void initEnvWithOptions(String regionId, String appName, String appGroup, String appEnv, Options options) throws CredProviderException {
        if (!envInitSuccess) {
            log.info("Initialize aliyun akless env with region-id: {}, app-name: {}, app-group: {}, app-env: {}", new Object[]{regionId, appName, appGroup, appEnv});
            try {
                AklessEnv.initEnv(Strings.nullToEmpty((String)regionId), Strings.nullToEmpty((String)appName), Strings.nullToEmpty((String)appGroup), Strings.nullToEmpty((String)appEnv), Strings.nullToEmpty((String)options.getBootstrapToken()), Strings.nullToEmpty((String)options.getIdToken()));
                envInitSuccess = true;
            }
            catch (Exception e) {
                log.error("Failed to init AklessCredProviderFactory environment: [{}]", (Object)e.toString());
                envInitSuccess = false;
                throw new CredProviderException(CredProviderCode.ErrEnvInit, String.format("Failed to init AklessCredProviderFactory: [%s]", e));
            }
        }
    }

    public static AklessCredentialClient getCredentialClient(String credentialArn) throws CredProviderException {
        CredentialProviderConfig config = new CredentialProviderConfig();
        config.setCredentialArn(credentialArn);
        return AklessCredProviderFactory.getCredentialClient(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AklessCredentialClient getCredentialClient(CredentialProviderConfig config) throws CredProviderException {
        AklessCredProviderFactory.credProviderInit(config);
        AklessCredProviderFactory.distributeCredentialArn(config);
        String key = AklessCredProviderFactory.getCredentialsProviderKey("AklessCredentialClient", config);
        AklessCredentialClient provider = (AklessCredentialClient)((Object)credentialsProviderCache.get(key));
        if (provider != null) {
            return provider;
        }
        Object object = lock;
        synchronized (object) {
            provider = (AklessCredentialClient)((Object)credentialsProviderCache.get(key));
            if (provider != null) {
                return provider;
            }
            log.info("Initialize credential client with credential arn: {}", (Object)config.getCredentialArn());
            provider = new AklessCredentialClient(config);
            credentialsProviderCache.put(key, (Object)provider);
            return provider;
        }
    }

    public static AklessCredentialsProvider getCredentialsProvider(String credentialArn) throws CredProviderException {
        CredentialProviderConfig config = new CredentialProviderConfig();
        config.setCredentialArn(credentialArn);
        return AklessCredProviderFactory.getCredentialsProvider(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AklessICredentialProvider getICredentialProvider(CredentialProviderConfig config) throws CredProviderException {
        AklessCredProviderFactory.credProviderInit(config);
        AklessCredProviderFactory.distributeCredentialArn(config);
        String key = AklessCredProviderFactory.getCredentialsProviderKey("AklessICredentialProvider", config);
        AklessICredentialProvider provider = (AklessICredentialProvider)credentialsProviderCache.get(key);
        if (provider != null) {
            return provider;
        }
        Object object = lock;
        synchronized (object) {
            provider = (AklessICredentialProvider)credentialsProviderCache.get(key);
            if (provider != null) {
                return provider;
            }
            log.info("Initialize credential provider with credential arn: {}", (Object)config.getCredentialArn());
            provider = new AklessICredentialProvider(config);
            credentialsProviderCache.put(key, provider);
            return provider;
        }
    }

    public static AklessICredentialProvider getICredentialProvider(String credentialArn) throws CredProviderException {
        CredentialProviderConfig config = new CredentialProviderConfig();
        config.setCredentialArn(credentialArn);
        return AklessCredProviderFactory.getICredentialProvider(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AklessCredentialsProvider getCredentialsProvider(CredentialProviderConfig config) throws CredProviderException {
        AklessCredProviderFactory.credProviderInit(config);
        AklessCredProviderFactory.distributeCredentialArn(config);
        String key = AklessCredProviderFactory.getCredentialsProviderKey("AklessCredentialsProvider", config);
        AklessCredentialsProvider provider = (AklessCredentialsProvider)credentialsProviderCache.get(key);
        if (provider != null) {
            return provider;
        }
        Object object = lock;
        synchronized (object) {
            provider = (AklessCredentialsProvider)credentialsProviderCache.get(key);
            if (provider != null) {
                return provider;
            }
            log.info("Initialize icredential provider with credential arn: {}", (Object)config.getCredentialArn());
            provider = new AklessCredentialsProvider(config);
            credentialsProviderCache.put(key, provider);
            return provider;
        }
    }

    public static AklessOssCredentialsProvider getOssCredentialProvider(String credentialArn) throws CredProviderException {
        CredentialProviderConfig config = new CredentialProviderConfig();
        config.setCredentialArn(credentialArn);
        return AklessCredProviderFactory.getOssCredentialProvider(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AklessOssCredentialsProvider getOssCredentialProvider(CredentialProviderConfig config) throws CredProviderException {
        AklessCredProviderFactory.credProviderInit(config);
        AklessCredProviderFactory.distributeCredentialArn(config);
        String key = AklessCredProviderFactory.getCredentialsProviderKey("AklessOssCredentialsProvider", config);
        AklessOssCredentialsProvider provider = (AklessOssCredentialsProvider)credentialsProviderCache.get(key);
        if (provider != null) {
            return provider;
        }
        Object object = lock;
        synchronized (object) {
            provider = (AklessOssCredentialsProvider)credentialsProviderCache.get(key);
            if (provider != null) {
                return provider;
            }
            log.info("Initialize OSS credential provider with credential arn: {}", (Object)config.getCredentialArn());
            provider = new AklessOssCredentialsProvider(config);
            credentialsProviderCache.put(key, provider);
            return provider;
        }
    }

    public static AklessSlsCredentialsProvider getSlsCredentialsProvider(String credentialArn) throws CredProviderException {
        CredentialProviderConfig config = new CredentialProviderConfig();
        config.setCredentialArn(credentialArn);
        return AklessCredProviderFactory.getSlsCredentialsProvider(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AklessSlsCredentialsProvider getSlsCredentialsProvider(CredentialProviderConfig config) throws CredProviderException {
        AklessCredProviderFactory.credProviderInit(config);
        AklessCredProviderFactory.distributeCredentialArn(config);
        String key = AklessCredProviderFactory.getCredentialsProviderKey("AklessSlsCredentialsProvider", config);
        AklessSlsCredentialsProvider provider = (AklessSlsCredentialsProvider)credentialsProviderCache.get(key);
        if (provider != null) {
            return provider;
        }
        Object object = lock;
        synchronized (object) {
            provider = (AklessSlsCredentialsProvider)credentialsProviderCache.get(key);
            if (provider != null) {
                return provider;
            }
            log.info("Initialize SLS credential provider with credential arn: {}", (Object)config.getCredentialArn());
            provider = new AklessSlsCredentialsProvider(config);
            credentialsProviderCache.put(key, provider);
            return provider;
        }
    }

    public static AklessOtsCredentialsProvider getOtsCredentialsProvider(String credentialArn) throws CredProviderException {
        CredentialProviderConfig config = new CredentialProviderConfig();
        config.setCredentialArn(credentialArn);
        return AklessCredProviderFactory.getOtsCredentialsProvider(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AklessOtsCredentialsProvider getOtsCredentialsProvider(CredentialProviderConfig config) throws CredProviderException {
        AklessCredProviderFactory.credProviderInit(config);
        AklessCredProviderFactory.distributeCredentialArn(config);
        String key = AklessCredProviderFactory.getCredentialsProviderKey("AklessOtsCredentialsProvider", config);
        AklessOtsCredentialsProvider provider = (AklessOtsCredentialsProvider)credentialsProviderCache.get(key);
        if (provider != null) {
            return provider;
        }
        Object object = lock;
        synchronized (object) {
            provider = (AklessOtsCredentialsProvider)credentialsProviderCache.get(key);
            if (provider != null) {
                return provider;
            }
            log.info("Initialize OTS credential provider with credential arn: {}", (Object)config.getCredentialArn());
            provider = new AklessOtsCredentialsProvider(config);
            credentialsProviderCache.put(key, provider);
            return provider;
        }
    }

    public static AklessOpensearchCredentialsProvider getOpensearchCredentialsProvider(String credentialArn) throws CredProviderException {
        CredentialProviderConfig config = new CredentialProviderConfig();
        config.setCredentialArn(credentialArn);
        return AklessCredProviderFactory.getOpensearchCredentialsProvider(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AklessOpensearchCredentialsProvider getOpensearchCredentialsProvider(CredentialProviderConfig config) throws CredProviderException {
        AklessCredProviderFactory.credProviderInit(config);
        AklessCredProviderFactory.distributeCredentialArn(config);
        String key = AklessCredProviderFactory.getCredentialsProviderKey("AklessOpensearchCredentialsProvider", config);
        AklessOpensearchCredentialsProvider provider = (AklessOpensearchCredentialsProvider)credentialsProviderCache.get(key);
        if (provider != null) {
            return provider;
        }
        Object object = lock;
        synchronized (object) {
            provider = (AklessOpensearchCredentialsProvider)credentialsProviderCache.get(key);
            if (provider != null) {
                return provider;
            }
            log.info("Initialize Opensearch credential provider with credential arn: {}", (Object)config.getCredentialArn());
            provider = new AklessOpensearchCredentialsProvider(config);
            credentialsProviderCache.put(key, provider);
            return provider;
        }
    }

    public static InnerKmsCredentialsProvider getInnerKmsAkCredentialsProvider(String secretName) throws Exception {
        CredentialProviderConfig config = new CredentialProviderConfig();
        config.setCredentialArn(secretName);
        return AklessCredProviderFactory.getInnerKmsAkCredentialsProvider(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InnerKmsCredentialsProvider getInnerKmsAkCredentialsProvider(CredentialProviderConfig config) throws Exception {
        AklessCredProviderFactory.credProviderInit(config);
        AklessCredProviderFactory.distributeCredentialArn(config);
        if (config.getCredentialArn() == null || !config.getCredentialArn().startsWith("itenant_aliyun:default")) {
            throw new CredProviderException(CredProviderCode.ErrInvalidSecretName, "the secret name provided is invalid: " + config.getCredentialArn());
        }
        AklessCredProviderFactory.initEnv(config.getRegionId(), config.getAppName(), config.getAppGroup(), config.getAppEnv());
        String key = "InnerKmsCredentialsProvider:" + config.getCredentialArn();
        InnerKmsCredentialsProvider provider = (InnerKmsCredentialsProvider)credentialsProviderCache.get(key);
        if (provider != null) {
            return provider;
        }
        Object object = lock;
        synchronized (object) {
            provider = (InnerKmsCredentialsProvider)credentialsProviderCache.get(key);
            if (provider != null) {
                return provider;
            }
            provider = new InnerKmsCredentialsProvider(config);
            credentialsProviderCache.put(key, provider);
            return provider;
        }
    }

    public static RawSecretCredentialsProvider getRawSecretCredentialsProvider(String secretName) throws Exception {
        CredentialProviderConfig config = new CredentialProviderConfig();
        config.setCredentialArn(secretName);
        return AklessCredProviderFactory.getRawSecretCredentialsProvider(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RawSecretCredentialsProvider getRawSecretCredentialsProvider(CredentialProviderConfig config) throws Exception {
        AklessCredProviderFactory.credProviderInit(config);
        AklessCredProviderFactory.distributeCredentialArn(config);
        if (config.getCredentialArn() == null || !config.getCredentialArn().startsWith("itenant_aliyun:default")) {
            throw new CredProviderException(CredProviderCode.ErrInvalidSecretName, "the secret name provided is invalid: " + config.getCredentialArn());
        }
        AklessCredProviderFactory.initEnv(config.getRegionId(), config.getAppName(), config.getAppGroup(), config.getAppEnv());
        String key = "RawSecretCredentialsProvider:" + config.getCredentialArn();
        RawSecretCredentialsProvider provider = (RawSecretCredentialsProvider)credentialsProviderCache.get(key);
        if (provider != null) {
            return provider;
        }
        Object object = lock;
        synchronized (object) {
            provider = (RawSecretCredentialsProvider)credentialsProviderCache.get(key);
            if (provider != null) {
                return provider;
            }
            provider = new RawSecretCredentialsProvider(config);
            credentialsProviderCache.put(key, provider);
            return provider;
        }
    }
}

