/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.common.utils;

import com.aliyun.akless.credprovider.plugin.common.environment.AklessEnv;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetAccessUtils {
    private static Logger log = LoggerFactory.getLogger(NetAccessUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkOpenPort(String domain, int port, int timeout) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(domain, port), timeout);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getAvailableEndpointWithRegionId(String[] endpoints) {
        for (int i = 0; i < 2; ++i) {
            String[] stringArray = endpoints;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String endpoint = stringArray[j];
                String finalEndpoint = String.format(endpoint, AklessEnv.getRegionId());
                if (NetAccessUtils.checkOpenPort(finalEndpoint, 80, 100)) {
                    return finalEndpoint;
                }
                if (!NetAccessUtils.checkOpenPort(finalEndpoint, 443, 100)) continue;
                return finalEndpoint;
            }
        }
        for (String endpoint : endpoints) {
            String finalEndpoint = String.format(endpoint, AklessEnv.getRegionId());
            if (NetAccessUtils.checkOpenPort(finalEndpoint, 80, 2000)) {
                return finalEndpoint;
            }
            if (!NetAccessUtils.checkOpenPort(finalEndpoint, 443, 2000)) continue;
            return finalEndpoint;
        }
        return null;
    }

    public static boolean checkAccessibility(String endpoint) {
        if (StringUtils.isBlank((CharSequence)endpoint)) {
            log.error("Failed to check empty domain");
        }
        for (int i = 0; i < 2; ++i) {
            if (NetAccessUtils.checkOpenPort(endpoint, 80, 100)) {
                return true;
            }
            if (!NetAccessUtils.checkOpenPort(endpoint, 443, 100)) continue;
            return true;
        }
        if (NetAccessUtils.checkOpenPort(endpoint, 80, 2000)) {
            return true;
        }
        return NetAccessUtils.checkOpenPort(endpoint, 443, 2000);
    }
}

