/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.common.utils;

import com.aliyun.akless.credprovider.plugin.common.error.CredProviderCode;
import com.aliyun.akless.credprovider.plugin.common.error.CredProviderException;
import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IDTokenUtils {
    private static Logger log = LoggerFactory.getLogger(IDTokenUtils.class);

    public static long getRemainValidTimeMills(String idToken) {
        try {
            DecodedJWT jwt = JWT.decode((String)idToken);
            long exp = jwt.getExpiresAt().getTime();
            log.debug("isExpired: exp {}, current {}", (Object)exp, (Object)System.currentTimeMillis());
            long current = System.currentTimeMillis();
            if (exp < current) {
                log.info("failed to get remaining valid time since it has expired");
                throw new CredProviderException(CredProviderCode.ErrIdTokenExpired, "failed to get remaining valid time since it has expired");
            }
            return exp - current;
        }
        catch (Exception e) {
            log.error("getRemainValidTimeMills: Failed to parse jwt: {}", (Object)e.toString());
            return -1L;
        }
    }

    public static long getValidTimeMills(String idToken) throws CredProviderException {
        try {
            DecodedJWT jwt = JWT.decode((String)idToken);
            long expTime = jwt.getExpiresAt().getTime();
            long signTime = jwt.getIssuedAt().getTime();
            return expTime - signTime;
        }
        catch (Exception e) {
            log.error("getValidTimeMills: Failed to parse jwt: {}", (Object)e.toString());
            throw new CredProviderException(CredProviderCode.ErrMalformedIdToken, String.format("getValidTimeMills: Failed to parse jwt: %s", e));
        }
    }

    public static String getTokenJti(String idToken) throws CredProviderException {
        try {
            DecodedJWT jwt = JWT.decode((String)idToken);
            return jwt.getId();
        }
        catch (Exception e) {
            log.error("getTokenID: Failed to parse jwt: {}", (Object)e.toString());
            throw new CredProviderException(CredProviderCode.ErrMalformedIdToken, String.format("getTokenID: Failed to parse jwt: %s", e));
        }
    }

    public static String getIssuer(String idToken) throws CredProviderException {
        try {
            DecodedJWT jwt = JWT.decode((String)idToken);
            return jwt.getIssuer();
        }
        catch (Exception e) {
            log.error("getIssuer: Failed to parse jwt: {}", (Object)e.toString());
            throw new CredProviderException(CredProviderCode.ErrMalformedIdToken, String.format("getIssuer: Failed to parse jwt: %s", e));
        }
    }

    public static String getKeyId(String idToken) throws CredProviderException {
        try {
            DecodedJWT jwt = JWT.decode((String)idToken);
            return jwt.getKeyId();
        }
        catch (Exception e) {
            log.error("getKeyId: Failed to parse jwt: {}", (Object)e.toString());
            throw new CredProviderException(CredProviderCode.ErrMalformedIdToken, String.format("getIssuer: Failed to parse jwt: %s", e));
        }
    }
}

