/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.common.log;

import com.alibaba.fastjson.JSON;
import com.aliyun.akless.credprovider.plugin.common.cred.AklessCredentials;
import com.aliyun.akless.credprovider.plugin.common.enums.LogRegionMap;
import com.aliyun.akless.credprovider.plugin.common.enums.NetworkEnvMode;
import com.aliyun.akless.credprovider.plugin.common.environment.AklessEnv;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogCode;
import com.aliyun.akless.credprovider.plugin.common.log.EventLogMessageKeys;
import com.aliyun.akless.credprovider.plugin.common.utils.NetAccessUtils;
import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.http.client.ClientConfiguration;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teaopenapi.models.OpenApiRequest;
import com.aliyun.teaopenapi.models.Params;
import com.aliyun.teautil.models.RuntimeOptions;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLogger {
    private static Client client;
    private static DateTimeFormatter formatter;
    private static String slsEndpoint;
    private static String slsProject;
    private static String authServerEndpoint;
    private static Timer timer;
    private static FetchSlsCredentialsTask task;
    private static volatile AklessCredentials slsCred;
    private static Logger log;

    public static void resetEventLogger() {
        if (AklessEnv.isInVPC()) {
            String[] endpoints = new String[]{"app-idp-inner-vpc.%s.aliyuncs.com", "app-idp-inner-2-vpc.%s.aliyuncs.com"};
            authServerEndpoint = NetAccessUtils.getAvailableEndpointWithRegionId(endpoints);
            slsProject = String.format("id-client-%s", AklessEnv.getRegionId());
            slsEndpoint = String.format("%s-intranet.log.aliyuncs.com", AklessEnv.getRegionId());
        } else if (AklessEnv.isInOXS()) {
            String logRegionId = LogRegionMap.getLogRegionId(AklessEnv.getRegionId());
            authServerEndpoint = String.format("app-idp-inner.%s.aliyuncs.com", AklessEnv.getRegionId());
            slsProject = String.format("id-client-%s", logRegionId);
            slsEndpoint = String.format("%s-intranet.log.aliyuncs.com", logRegionId);
        } else if (AklessEnv.isInOffice()) {
            authServerEndpoint = "app-idp-inner-share.aliyuncs.com";
            slsProject = "id-client-share";
            slsEndpoint = "cn-hangzhou-share.log.aliyuncs.com";
        } else if (AklessEnv.isInTanneiProduction()) {
            authServerEndpoint = String.format("app-idp-inner-tannei-%s.aliyuncs.com", AklessEnv.getRegionId());
            slsProject = "id-client-share";
            slsEndpoint = "cn-hangzhou-share.log.aliyuncs.com";
        } else if (AklessEnv.getNetworkEnv() == NetworkEnvMode.IDPT_OXS) {
            authServerEndpoint = String.format("app-idp-inner-intranet.%s.%scs.com", AklessEnv.getRegionId(), AklessEnv.getBaseDomain());
            slsProject = String.format("id-client-%s", AklessEnv.getRegionId());
            int idx = AklessEnv.getRegionId().indexOf("idpt-");
            if (idx == -1) {
                slsEndpoint = String.format("log-intranet.%s.%scs.com", AklessEnv.getRegionId(), AklessEnv.getBaseDomain());
            } else {
                int insertPos = idx + "idpt-".length();
                slsEndpoint = String.format("data.%s.sls-pub.inter.%s-inner-private.com", AklessEnv.getRegionId().substring(0, insertPos) + "inner-" + AklessEnv.getRegionId().substring(insertPos), AklessEnv.getBaseDomain());
            }
        } else if (AklessEnv.getNetworkEnv() == NetworkEnvMode.IDPT_VPC) {
            authServerEndpoint = String.format("app-idp-inner-vpc.%s.%scs.com", AklessEnv.getRegionId(), AklessEnv.getBaseDomain());
            slsProject = String.format("id-client-%s", AklessEnv.getRegionId());
            slsEndpoint = String.format("log-internal.%s.%scs.com", AklessEnv.getRegionId(), AklessEnv.getBaseDomain());
        } else if (AklessEnv.getNetworkEnv() == NetworkEnvMode.ALIYUN_TEST) {
            authServerEndpoint = String.format("app-idp-inner-share.%s.aliyuncs.com", AklessEnv.getRegionId());
            slsProject = "id-client-share";
            slsEndpoint = "cn-hangzhou-share.log.aliyuncs.com";
        } else {
            authServerEndpoint = "app-idp-inner-daily.aliyuncs.com";
            slsProject = "id-client-share";
            slsEndpoint = "cn-hangzhou-share.log.aliyuncs.com";
        }
        FetchSlsCredentialsTask.internalGetCredentials();
        timer = new Timer(true);
        task = new FetchSlsCredentialsTask();
        timer.schedule((TimerTask)task, 600000L, 600000L);
        ClientConfiguration config = new ClientConfiguration();
        config.setSocketTimeout(1000);
        config.setConnectionTimeout(1000);
        config.setRequestTimeoutEnabled(true);
        config.setRequestTimeout(1500);
        client = new Client(slsEndpoint, "DummyKeyId", "DummyKeySecret", config);
    }

    private static void internalSend(LogItem item, EventLogCode eventLogCode, String messageLog) throws LogException {
        item.PushBack("Time", formatter.format(Instant.ofEpochMilli(System.currentTimeMillis())));
        item.PushBack("AklessEnv", AklessEnv.AklessEnvString);
        item.PushBack("EventCatalog", eventLogCode.getEventCode().getEventCode());
        item.PushBack("Level", eventLogCode.getLogLevel());
        item.PushBack("EventCode", eventLogCode.getLogCode());
        try {
            item.PushBack("Pid", ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        item.PushBack("Message", messageLog);
        ArrayList<LogItem> logGroup = new ArrayList<LogItem>();
        logGroup.add(item);
        if (slsCred == null) {
            log.error("failed to find valid sls credentials");
            return;
        }
        AklessCredentials credentials = slsCred;
        client.setAccessId(credentials.getAccessKeyId());
        client.setAccessKey(credentials.getAccessKeySecret());
        client.setSecurityToken(credentials.getSessionToken());
        client.PutLogs(slsProject, "credprovider-eventlogger", "", logGroup, "");
    }

    public static void send(EventLogCode eventLogCode, Map<String, String> topLevelLogItem, Map<String, Object> secondLevelLog) {
        try {
            HashMap<String, Object> messageLog = new HashMap<String, Object>();
            if (secondLevelLog != null && eventLogCode.getSpecificMessageKeys() != null) {
                for (EventLogMessageKeys key : eventLogCode.getSpecificMessageKeys()) {
                    messageLog.put(key.getValue(), secondLevelLog.get(key.getValue()));
                }
            }
            LogItem item = new LogItem((int)(new Date().getTime() / 1000L));
            if (topLevelLogItem != null) {
                for (String key : topLevelLogItem.keySet()) {
                    item.PushBack(key, topLevelLogItem.get(key));
                }
            }
            EventLogger.internalSend(item, eventLogCode, JSON.toJSONString(messageLog));
        }
        catch (Exception e) {
            log.error("Failed to send log: {}", (Object)e.toString());
        }
    }

    static {
        formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mmZ").withZone(ZoneId.of("UTC+8"));
        authServerEndpoint = null;
        slsCred = null;
        log = LoggerFactory.getLogger(EventLogger.class);
    }

    public static class FetchSlsCredentialsTask
    extends TimerTask {
        @Override
        public void run() {
            FetchSlsCredentialsTask.internalGetCredentials();
        }

        public static void internalGetCredentials() {
            Object connection = null;
            Object reader = null;
            if (authServerEndpoint == null) {
                String[] endpoints = new String[]{"app-idp-inner-vpc.%s.aliyuncs.com", "app-idp-inner-2-vpc.%s.aliyuncs.com"};
                authServerEndpoint = NetAccessUtils.getAvailableEndpointWithRegionId(endpoints);
                if (authServerEndpoint == null) {
                    return;
                }
            }
            if (slsCred != null && !slsCred.needsRefresh()) {
                return;
            }
            try {
                Config config = new Config().setEndpoint(authServerEndpoint).setUserAgent("Aliyun Security CP SDK/Java 1.10.2").setReadTimeout(Integer.valueOf(1500)).setConnectTimeout(Integer.valueOf(1000));
                com.aliyun.teaopenapi.Client client = new com.aliyun.teaopenapi.Client(config);
                Params params = new Params().setStyle("RPC").setVersion("2023-03-01").setMethod("GET").setAction("GetLogCredential").setPathname("/").setProtocol("HTTPS").setAuthType("Anonymous").setReqBodyType("json").setBodyType("json");
                HashMap<String, String> queries = new HashMap<String, String>();
                queries.put("Format", "JSON");
                OpenApiRequest request = new OpenApiRequest().setQuery(com.aliyun.openapiutil.Client.query(queries));
                RuntimeOptions runtime = new RuntimeOptions();
                runtime.setAutoretry(Boolean.valueOf(true));
                runtime.setMaxAttempts(Integer.valueOf(1));
                Map response = client.callApi(params, request, runtime);
                Map body = (Map)response.get("body");
                Map credentials = (Map)body.get("Credentials");
                slsCred = new AklessCredentials((String)credentials.get("AccessKeyId"), (String)credentials.get("AccessKeySecret"), (String)credentials.get("SecurityToken"), (String)credentials.get("Expiration"));
            }
            catch (Exception e) {
                log.error("failed to get sls credential from auth server: {}", (Object)e.toString());
            }
        }
    }
}

