/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.common.credprovider;

import com.aliyun.akless.credprovider.plugin.common.cred.AklessCredentials;
import com.aliyun.akless.credprovider.plugin.common.credprovider.BaseCredentialsProvider;
import com.aliyun.akless.credprovider.plugin.common.error.CredProviderException;
import com.aliyun.akless.credprovider.plugin.common.log.CredentialsProviderType;
import com.aliyun.akless.credprovider.plugin.core.CredentialProviderConfig;
import com.aliyun.credentials.Client;
import com.aliyun.credentials.models.CredentialModel;

public class AklessCredentialClient
extends Client {
    private BaseCredentialsProvider baseCredentialsProvider;
    private final ThreadLocal<AklessCredentials> theadLocalCredentials = new ThreadLocal();

    public AklessCredentialClient(CredentialProviderConfig config) throws CredProviderException {
        this.baseCredentialsProvider = new BaseCredentialsProvider(config, CredentialsProviderType.CredentialsClient.getValue());
    }

    public CredentialModel getCredential() {
        AklessCredentials credentials = this.baseCredentialsProvider.manager.getCredentials();
        if (credentials == null) {
            return null;
        }
        return credentials.getOpenSDKV2Credential();
    }

    private AklessCredentials setThreadLocalCredentials() {
        AklessCredentials credentials = this.baseCredentialsProvider.manager.getCredentials();
        if (credentials != null) {
            this.theadLocalCredentials.set(credentials);
        }
        return credentials;
    }

    public String getAccessKeyId() {
        AklessCredentials credentials = this.setThreadLocalCredentials();
        return credentials != null ? credentials.getAccessKeyId() : null;
    }

    public String getAccessKeySecret() {
        AklessCredentials credentials = this.theadLocalCredentials.get();
        if (credentials == null) {
            credentials = this.setThreadLocalCredentials();
        }
        return credentials != null ? credentials.getAccessKeySecret() : null;
    }

    public String getSecurityToken() {
        AklessCredentials credentials = this.theadLocalCredentials.get();
        if (credentials == null) {
            credentials = this.setThreadLocalCredentials();
        }
        return credentials != null ? credentials.getSessionToken() : null;
    }

    public String getType() {
        return "sts";
    }

    public String getBearerToken() {
        return null;
    }
}

