/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.akless.credprovider.plugin.common.cred;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.opensearch.auth.credential.StsCredentials;
import com.aliyun.openservices.log.common.auth.Credentials;
import com.aliyun.openservices.log.common.auth.DefaultCredentials;
import com.aliyuncs.auth.BasicSessionCredentials;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AklessCredentials
extends BasicSessionCredentials {
    private Logger log = LoggerFactory.getLogger(AklessCredentials.class);
    private String expiration;
    private long issueAtUnixEpochSeconds;
    private String issueAt;
    private Long stsTokenDurationSeconds;
    private Long threshold;
    private String type;
    private String rawSecret;

    public AklessCredentials(String accessKeyId, String accessKeySecret, String sessionToken, String expiration) {
        super(accessKeyId, accessKeySecret, sessionToken);
        String formatted;
        this.expiration = expiration;
        LocalDateTime dateTime = LocalDateTime.now(ZoneOffset.UTC);
        this.issueAt = formatted = dateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'"));
        this.stsTokenDurationSeconds = (Instant.parse(this.expiration).toEpochMilli() - System.currentTimeMillis()) / 1000L;
        this.issueAtUnixEpochSeconds = System.currentTimeMillis() / 1000L;
        this.threshold = Math.min(14400L, this.stsTokenDurationSeconds / 2L) - (long)(Math.random() * 61.0);
        this.type = sessionToken == null || sessionToken.isEmpty() ? "access_key" : "sts";
    }

    public static AklessCredentials fromRawSecret(String secret) {
        AklessCredentials aklessCredentials = new AklessCredentials("", "", "", "2023-09-12T08:14:25Z");
        aklessCredentials.rawSecret = secret;
        aklessCredentials.type = "raw_secret";
        return aklessCredentials;
    }

    public Credential getICredentials() {
        return Credential.builder().accessKeyId(this.getAccessKeyId()).accessKeySecret(this.getAccessKeySecret()).securityToken(this.getSessionToken()).build();
    }

    public BasicSessionCredentials getPopBasicSessionCredentials() {
        return new BasicSessionCredentials(this.getAccessKeyId(), this.getAccessKeySecret(), this.getSessionToken());
    }

    public com.aliyun.oss.common.auth.DefaultCredentials getOssDefaultCredentials() {
        if ("".equals(this.getSessionToken())) {
            return new com.aliyun.oss.common.auth.DefaultCredentials(this.getAccessKeyId(), this.getAccessKeySecret());
        }
        return new com.aliyun.oss.common.auth.DefaultCredentials(this.getAccessKeyId(), this.getAccessKeySecret(), this.getSessionToken());
    }

    public Credentials getSlsCredentials() {
        return new DefaultCredentials(this.getAccessKeyId(), this.getAccessKeySecret(), this.getSessionToken());
    }

    public com.alicloud.openservices.tablestore.core.auth.DefaultCredentials getOtsCredentials() {
        return new com.alicloud.openservices.tablestore.core.auth.DefaultCredentials(this.getAccessKeyId(), this.getAccessKeySecret(), this.getSessionToken());
    }

    public CredentialModel getOpenSDKV2Credential() {
        CredentialModel.Builder builder = new CredentialModel.Builder().accessKeyId(this.getAccessKeyId()).accessKeySecret(this.getAccessKeySecret()).securityToken(this.getSessionToken()).type("sts");
        return builder.build();
    }

    public StsCredentials getOpensearchCredentials() {
        return new StsCredentials(this.getAccessKeyId(), this.getAccessKeySecret(), this.getSessionToken());
    }

    public String getExpiration() {
        return this.expiration;
    }

    public String getIssueAt() {
        return this.issueAt;
    }

    public boolean needsRefresh() {
        try {
            return System.currentTimeMillis() / 1000L - this.issueAtUnixEpochSeconds > this.threshold;
        }
        catch (Exception e) {
            this.log.error("Failed to parse STS Token expiration time: {}", (Object)e.toString());
            return true;
        }
    }

    public String getRawSecret() {
        return this.rawSecret;
    }

    public String getType() {
        return this.type;
    }
}

