/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.spec.domain.ConnectionMapping;
import com.aliyun.migration.spec.domain.DataArtsJobParamDTO;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfig;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigInput;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigValues;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobExtendedConfigs;
import com.aliyun.migration.spec.domain.constant.DataArtsConstant;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.DISetpTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.annotation.DIRef;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.config.DataArtsDiConfig;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStep;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStepParameter;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.Base64Utils;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.util.DataArtsUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DIRef(value="POSTGRESQL_STEP_TYPE")
public class PostgresqlStepTypeHandler
implements DISetpTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(PostgresqlStepTypeHandler.class);

    @Override
    public DiScriptStep convertToDwSourceStep(DataArtsDiConfig config, List<DataArtsJobParamDTO> jobParams, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) {
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Reader");
        diScriptStep.setStepType("postgresql");
        diScriptStep.setCategory("reader");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        setepParameter.setDatasource(config.getConnectionMapping(dataArtsLinkName).getDwConnectionName());
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        String schemaName = "public";
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("fromJobConfig.useSql".equals(input.getName()) && Boolean.valueOf(input.getValue()).booleanValue()) {
                setepParameter.setQuery(DataArtsUtil.getSql(inputList));
                continue;
            }
            if ("fromJobConfig.tableName".equals(input.getName())) {
                setepParameter.setTable(input.getValue());
                continue;
            }
            if ("fromJobConfig.columnList".equals(input.getName())) {
                ArrayList<String> columnList = new ArrayList<String>();
                for (String column : input.getValue().split("&")) {
                    columnList.add(column);
                }
                setepParameter.setColumn(columnList);
                continue;
            }
            if ("fromJobConfig.whereClause".equals(input.getName())) {
                setepParameter.setWhere(Base64Utils.decodeUtf8(input.getValue()));
                continue;
            }
            if ("fromJobConfig.schemaName".equals(input.getName())) {
                schemaName = input.getValue();
                continue;
            }
            if (!"fromJobConfig.partitionColumn".equals(input.getName())) continue;
            setepParameter.setSplitPk(input.getValue());
        }
        setepParameter.setTable(schemaName + "." + setepParameter.getTable());
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DataArtsDiConfig config, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) {
        DataArtsCdmJobConfig dataArtsCdmJobConfig = (DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0);
        DataArtsCdmJobExtendedConfigs dataArtsCdmJobExtendedConfigs = dataArtsCdmJobConfigValues.getExtendedConfigs();
        ConnectionMapping dwFromDataSource = config.getConnectionMapping(dataArtsLinkName);
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Writer");
        diScriptStep.setStepType("postgresql");
        diScriptStep.setCategory("writer");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        setepParameter.setDatasource(dwFromDataSource.getDwConnectionName());
        ArrayList<String> preSql = new ArrayList<String>();
        if (dataArtsCdmJobExtendedConfigs != null && "toJobConfig.extendedFields".equals(dataArtsCdmJobExtendedConfigs.getName()) && StringUtils.isNotEmpty((CharSequence)dataArtsCdmJobExtendedConfigs.getValue())) {
            String extendedFieldsValue = null;
            try {
                extendedFieldsValue = new String(Base64.getDecoder().decode(dataArtsCdmJobExtendedConfigs.getValue()));
            }
            catch (Exception e) {
                log.error("toJobConfig.extendedFields decode error", (Throwable)e);
            }
            final JSONObject extendedFieldsValueJson = JSON.parseObject((String)extendedFieldsValue);
            if (extendedFieldsValueJson.containsKey("preSql")) {
                preSql.add(extendedFieldsValueJson.getString("presql"));
            }
            if (extendedFieldsValueJson.containsKey("postSql")) {
                setepParameter.setPostSql((List<String>)new ArrayList<String>(){
                    {
                        this.add(extendedFieldsValueJson.getString("presql"));
                    }
                });
            }
        }
        boolean deleteAllOldData = false;
        List inputList = dataArtsCdmJobConfig.getInputs();
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("toJobConfig.tableName".equals(input.getName())) {
                setepParameter.setTable(input.getValue());
                continue;
            }
            if ("toJobConfig.columnList".equals(input.getName())) {
                setepParameter.setColumn(Arrays.asList(input.getValue().split("&")));
                continue;
            }
            if (!"toJobConfig.beforeImportType".equals(input.getName()) || !input.getValue().equals("shouldClearTable")) continue;
            deleteAllOldData = true;
        }
        if (deleteAllOldData) {
            preSql.add("DELETE  from " + setepParameter.getTable() + ";");
        }
        setepParameter.setBatchSize(DataArtsConstant.DW_DI_SYNC_BATCH_SIZE);
        setepParameter.setPreSql(preSql);
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }

    public static void main(String[] args) {
        ArrayList<String> columnList1 = new ArrayList<String>();
        columnList1.add("user");
        columnList1.add("name");
        ArrayList<CallSite> columnList = new ArrayList<CallSite>();
        for (String string : columnList1) {
            String string2 = "\"" + string + "\"";
            columnList.add((CallSite)((Object)string2));
        }
        System.err.println(JSONObject.toJSONString(columnList, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
    }
}

