/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert.di;

import com.aliyun.migration.spec.domain.ConnectionMapping;
import com.aliyun.migration.spec.domain.DataArtsJobParamDTO;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfig;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigInput;
import com.aliyun.migration.spec.domain.cdm.DataArtsCdmJobConfigValues;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.DISetpTypeHandler;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.annotation.DIRef;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.config.DataArtsDiConfig;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStep;
import com.workflow.migration.transform.dw.converter.dataarts.convert.di.domain.DiScriptStepParameter;
import io.micrometer.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DIRef(value="ELASTICSEARCH_STEP_TYPE")
public class ElasticStepTypeHandler
implements DISetpTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(ElasticStepTypeHandler.class);
    List<String> blcakColumnList = new ArrayList<String>();

    public void initReadColumnBlck() {
        this.blcakColumnList.add("_id");
        this.blcakColumnList.add("_index");
        this.blcakColumnList.add("_score");
        this.blcakColumnList.add("_type");
    }

    @Override
    public DiScriptStep convertToDwSourceStep(DataArtsDiConfig config, List<DataArtsJobParamDTO> jobParams, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) {
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Reader");
        diScriptStep.setStepType("elasticsearch");
        diScriptStep.setCategory("reader");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        setepParameter.setDatasource(config.getConnectionMapping(dataArtsLinkName).getDwConnectionName());
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        for (DataArtsCdmJobConfigInput input : inputList) {
            if ("fromJobConfig.index".equals(input.getName())) {
                setepParameter.setIndex(input.getValue());
                continue;
            }
            if ("fromJobConfig.type".equals(input.getName())) {
                setepParameter.setType(input.getValue());
                continue;
            }
            if ("fromJobConfig.columnList".equals(input.getName())) {
                List<String> sourceColumnList = Arrays.asList(input.getValue().toLowerCase(Locale.ROOT).split("&"));
                ArrayList<String> targetColumnList = new ArrayList<String>();
                for (String column : sourceColumnList) {
                    String columnName = column.split(":")[0];
                    if (this.blcakColumnList.contains(columnName)) continue;
                    targetColumnList.add(columnName);
                }
                setepParameter.setColumn(targetColumnList);
                continue;
            }
            if ("fromJobConfig.queryString".equals(input.getName()) && !StringUtils.isNotEmpty((String)input.getValue())) continue;
        }
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }

    @Override
    public DiScriptStep convertToDwDestStep(DataArtsDiConfig config, DataArtsCdmJobConfigValues dataArtsCdmJobConfigValues, String dataArtsLinkName) {
        ConnectionMapping dwFromDataSource = config.getConnectionMapping(dataArtsLinkName);
        DiScriptStep diScriptStep = new DiScriptStep();
        diScriptStep.setName("Writer");
        diScriptStep.setStepType("elasticsearch");
        diScriptStep.setCategory("writer");
        DiScriptStepParameter setepParameter = new DiScriptStepParameter();
        setepParameter.setDatasource(dwFromDataSource.getDwConnectionName());
        List inputList = ((DataArtsCdmJobConfig)dataArtsCdmJobConfigValues.getConfigs().get(0)).getInputs();
        DiScriptStepParameter.PrimaryKeyInfo primaryKeyInfo = new DiScriptStepParameter.PrimaryKeyInfo();
        primaryKeyInfo.setType("nopk");
        setepParameter.setPrimaryKeyInfo(primaryKeyInfo);
        for (final DataArtsCdmJobConfigInput input : inputList) {
            if ("toJobConfig.index".equals(input.getName())) {
                setepParameter.setIndex(input.getValue());
                continue;
            }
            if ("toJobConfig.type".equals(input.getName())) {
                setepParameter.setIndexType(input.getValue());
                continue;
            }
            if ("toJobConfig.columnList".equals(input.getName())) {
                List<String> sourceColumnList = Arrays.asList(input.getValue().toLowerCase(Locale.ROOT).split("&"));
                ArrayList targetColumnList = new ArrayList();
                for (String column : sourceColumnList) {
                    String[] columnValueArray = column.split(":");
                    HashMap<String, String> columnMap = new HashMap<String, String>();
                    columnMap.put("name", columnValueArray[0]);
                    columnMap.put("type", columnValueArray[1]);
                    targetColumnList.add(columnMap);
                }
                setepParameter.setColumn(targetColumnList);
                continue;
            }
            if ("toJobConfig.shouldClearTable".equals(input.getName())) {
                setepParameter.setCleanup(Boolean.valueOf(input.getValue()));
                continue;
            }
            if (!"toJobConfig.primaryKey".equals(input.getName()) || !StringUtils.isNotEmpty((String)input.getValue())) continue;
            primaryKeyInfo.setType("pk");
            primaryKeyInfo.setColumn((List<String>)new ArrayList<String>(){
                {
                    this.add(input.getValue().substring(0, input.getValue().indexOf(":")));
                }
            });
        }
        diScriptStep.setParameter(setepParameter);
        return diScriptStep;
    }
}

