/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.type.DataArtsNodeType;
import com.aliyun.migration.workflow.migration.common.type.DbType;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(SqlConvert.class);

    public SqlConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public SqlConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> res = new ArrayList<WorkflowNode>();
        ((List)Optional.ofNullable(workflowNodes).orElse(new ArrayList())).forEach(x -> {
            WorkflowNode workflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)x, WorkflowNode.class);
            if (Objects.isNull(workflowNode)) {
                log.error("convert node failed,{}", (Object)x.getNodeName());
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_CONVERT_FAILED);
            }
            switch (DataArtsNodeType.valueOf((String)workflowNode.getNodeType())) {
                case HiveSQL: {
                    workflowNode.setDbType(DbType.HIVE.getDescp());
                    workflowNode.setNodeType(CodeProgramType.ODPS_SQL.getName());
                    break;
                }
                case DWSSQL: {
                    workflowNode.setDbType(DbType.GAUSSDB.getDescp());
                    workflowNode.setNodeType(CodeProgramType.ODPS_SQL.getName());
                    break;
                }
                case RDSSQL: {
                    workflowNode.setDbType(DbType.MYSQL.getDescp());
                    workflowNode.setNodeType(CodeProgramType.ODPS_SQL.getName());
                    break;
                }
                case DLISQL: {
                    workflowNode.setDbType(DbType.DLI.getDescp());
                    workflowNode.setNodeType(CodeProgramType.ODPS_SQL.getName());
                    break;
                }
                case SparkSQL: {
                    workflowNode.setDbType(DbType.SPARK.getDescp());
                    workflowNode.setNodeType(CodeProgramType.ODPS_SQL.getName());
                    break;
                }
                default: {
                    workflowNode.setDbType(DbType.UNKUNWN.getDescp());
                    workflowNode.setNodeType(CodeProgramType.ODPS_SQL.getName());
                }
            }
            res.add(workflowNode);
        });
        return res;
    }
}

