/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.convert.sparkContent.SparkContent;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(SparkConvert.class);

    public SparkConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public SparkConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> res = new ArrayList<WorkflowNode>();
        ((List)Optional.ofNullable(workflowNodes).orElse(new ArrayList())).forEach(x -> {
            String param;
            WorkflowNode workflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)x, WorkflowNode.class);
            if (Objects.isNull(workflowNode)) {
                log.error("convert node failed,{}", (Object)x.getNodeName());
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_CONVERT_FAILED);
            }
            if (workflowNode.getCustomProperties() != null && workflowNode.getCustomProperties().containsKey("programParameter") && (param = (String)workflowNode.getCustomProperties().get("programParameter")).contains("--class=")) {
                String className = param.substring(param.indexOf("--class=") + "--class=".length());
                className = className.split(" ")[0];
                workflowNode.getCustomProperties().put("mainClass", className);
            }
            if (workflowNode.getCustomProperties() != null && workflowNode.getCustomProperties().containsKey("resourcePath")) {
                String resourcePath = (String)workflowNode.getCustomProperties().get("resourcePath");
                String[] resP = resourcePath.split("/");
                if (workflowNode.getRuntimeResource() == null) {
                    workflowNode.setRuntimeResource(new HashMap());
                }
                workflowNode.getRuntimeResource().put(resP[resP.length - 1], resourcePath);
            }
            if (workflowNode.getRuntimeResource() != null) {
                SparkContent content = new SparkContent(workflowNode.getCustomProperties(), workflowNode.getRuntimeResource());
                workflowNode.setScript(content.getContent());
            }
            workflowNode.setNodeType(CodeProgramType.ODPS_SPARK.getName());
            res.add(workflowNode);
        });
        return res;
    }
}

