/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dataarts.convert;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLISparkConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(DLISparkConvert.class);

    public DLISparkConvert(TaskContext taskContext) {
        super(taskContext);
    }

    public DLISparkConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext, workflow);
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        ArrayList<WorkflowNode> res = new ArrayList<WorkflowNode>();
        ((List)Optional.ofNullable(workflowNodes).orElse(new ArrayList())).forEach(x -> {
            WorkflowNode workflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)x, WorkflowNode.class);
            if (Objects.isNull(workflowNode)) {
                log.error("convert node failed,{}", (Object)x.getNodeName());
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_CONVERT_FAILED);
            }
            if (workflowNode.getCustomProperties() == null) {
                workflowNode.setCustomProperties(new HashMap());
            }
            workflowNode.setNodeType(CodeProgramType.ODPS_SPARK.getName());
            JSONObject sparkConfig = new JSONObject();
            if (workflowNode.getCustomProperties().containsKey("sparkVersion") && ((String)workflowNode.getCustomProperties().get("sparkVersion")).startsWith("3.")) {
                sparkConfig.put((Object)"version", (Object)"3.x");
            } else {
                sparkConfig.put((Object)"version", (Object)"2.x");
            }
            sparkConfig.put((Object)"language", (Object)"java");
            if (workflowNode.getCustomProperties().containsKey("jobClass")) {
                sparkConfig.put((Object)"mainClass", workflowNode.getCustomProperties().get("jobClass"));
            }
            if (workflowNode.getCustomProperties().containsKey("jarArgs") && !((String)workflowNode.getCustomProperties().get("jarArgs")).isEmpty()) {
                sparkConfig.put((Object)"args", (Object)((String)workflowNode.getCustomProperties().get("jarArgs")).replaceAll("\n", " "));
            }
            ArrayList<Object> configList = new ArrayList<Object>();
            if (workflowNode.getCustomProperties().containsKey("executorCores")) {
                configList.add("spark.executor.cores=" + workflowNode.getCustomProperties().get("executorCores"));
            }
            if (workflowNode.getCustomProperties().containsKey("executorMemory")) {
                configList.add("spark.executor.memory=" + ((String)workflowNode.getCustomProperties().get("executorMemory")).toLowerCase());
            }
            if (workflowNode.getCustomProperties().containsKey("driverCores")) {
                configList.add("spark.driver.cores=" + workflowNode.getCustomProperties().get("driverCores"));
            }
            if (workflowNode.getCustomProperties().containsKey("driverMemory")) {
                configList.add("spark.driver.memory=" + ((String)workflowNode.getCustomProperties().get("driverMemory")).toLowerCase());
            }
            if (workflowNode.getCustomProperties().containsKey("sparkConfig") && !StringUtils.isEmpty((String)((String)workflowNode.getCustomProperties().get("sparkConfig")))) {
                configList.addAll(Arrays.stream(((String)workflowNode.getCustomProperties().get("sparkConfig")).split("\n")).toList());
            }
            sparkConfig.put((Object)"configs", configList);
            if (workflowNode.getCustomProperties().containsKey("resourcePath")) {
                String resourcePath = (String)workflowNode.getCustomProperties().get("resourcePath");
                String jarFileName = Arrays.stream(resourcePath.split("/")).toList().get(resourcePath.split("/").length - 1);
                sparkConfig.put((Object)"mainJar", (Object)(jarFileName + ".jar"));
            }
            workflowNode.setScript(sparkConfig.toJSONString(new JSONWriter.Feature[0]));
            res.add(workflowNode);
        });
        return res;
    }
}

